% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numPairDeColNames.R
\name{numPairDeColNames}
\alias{numPairDeColNames}
\title{Extract pair of numeric values from vector or column-names}
\usage{
numPairDeColNames(
  dat,
  selComp = NULL,
  stripTxt = NULL,
  sep = "-",
  columLabel = "conc",
  sortByAbsRatio = FALSE,
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{dat}{(matrix or data.frame) main input}

\item{selComp}{(character) the column index selected}

\item{stripTxt}{(character, max length=2) text to ignore, if NULL heading letter and punctuation characters will be removed; default will remove all letters (and following spaces)}

\item{sep}{(character, length=1) separator between pair of numeric values to extract}

\item{columLabel}{(character) column labels in output}

\item{sortByAbsRatio}{(logical) optional sorting of output by (absolute) log-ratios (most extreme ratios on top)}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
matrix
}
\description{
This function extracts a pair of numeric values out of a vector or colnames (from a matrix). 
This is useful when pairwise comparisons are concatenated like '10c-100c', return matrix with 'index'=selComp, log2rat and both numeric.
Additional white space or character text can be removed via the argument \code{stripTxt}.
Of course, the separator \code{sep} needs to be specified and should not be included to 'stripTxt'.
}
\examples{
##  composed column names
mat1 <- matrix(1:8, nrow=2, dimnames=list(NULL, paste0(1:4,"-",6:9)))
numPairDeColNames(mat1)
numPairDeColNames(colnames(mat1))
##  works also with simple numeric column names
mat2 <- matrix(1:8, nrow=2, dimnames=list(NULL, paste0("a",6:9)))
numPairDeColNames(mat2)
}
\seealso{
\code{\link[base]{strsplit}} and help on regex
}
