% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/completeArrLst.R
\name{completeArrLst}
\alias{completeArrLst}
\title{Complete list of arrays for same dimensions}
\usage{
completeArrLst(arrLst, silent = FALSE, callFrom = NULL)
}
\arguments{
\item{arrLst}{(list) list of arrays (typically 1st and 2nd dim for specific genes/objects, 3rd for different measures associated with)}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allows easier tracking of message(s) produced}
}
\value{
list of arrays, now with same dimension of arrays
}
\description{
This functions aims to inspect repeating structues of data given as list of arrays and will try to complete 
arrays with fewer lines or columns (as this may appear eg with the very last set of high-thourput sceening data 
if fewer measures remain in the last set). Thus, the dimensions of the arrays are compared and 
cases with fewer (lost) columns (eg fewer experimental replicates) will be adjust/complete  by adding column(s) of NA.
Used eg when at reading mircotiterplate data the last set is not complete.
}
\examples{
arr1 <- array(1:24,dim=c(4,3,2),dimnames=list(c(LETTERS[1:4]),
  paste("col",1:3,sep=""),c("ch1","ch2")))
arr3 <- array(81:96,dim=c(4,2,2),dimnames=list(c(LETTERS[1:4]),
  paste("col",1:2,sep=""),c("ch1","ch2")))
arrL3 <- list(pl1=arr1,pl3=arr3)
completeArrLst(arrL3)
}
\seealso{
\code{\link[wrMisc]{organizeAsListOfRepl}}, \code{\link[wrMisc]{extr1chan}}
}
