% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrayCV.R
\name{arrayCV}
\alias{arrayCV}
\title{CV of array}
\usage{
arrayCV(arr, byDim = 3, silent = TRUE, callFrom = NULL)
}
\arguments{
\item{arr}{(3-dim) array of numeric data like where replicates are along one dimesion of the array}

\item{byDim}{(integer) over which dimension repliates are found}

\item{silent}{(logical) suppres messages}

\item{callFrom}{(character) allow easier tracking of message produced}
}
\value{
matrix of CV values
}
\description{
\code{arrayCV} gets CVs for replicates in 2 or 3 dim array and returns CVs as matrix.
This function may be used to calculate CVs from replicate microtiter plates (eg 8x12) where replicates are typically done as multiple plates,
ie initial matrixes that are the organized into arrays.
}
\examples{
set.seed(2016); dat1 <- matrix(c(runif(200)+rep(1:10,20)),ncol=10)
head(arrayCV(dat1,byDim=2))
}
\seealso{
\code{\link[wrMisc]{rowCVs}}, \code{\link[wrMisc]{rowGrpCV}}, \code{\link[wrMisc]{replPlateCV}}
}
