% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colSds.R
\name{colSds}
\alias{colSds}
\title{sd for each column}
\usage{
colSds(dat, silent = FALSE, debug = FALSE, callFrom = NULL)
}
\arguments{
\item{dat}{matrix (or data.frame) with numeric values (may contain NAs which will be ignored)}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allows easier tracking of messages produced}
}
\value{
numeric vector of sd values
}
\description{
This function is speed optimized \code{sd} per column of a matrix or data.frame and treats each column as independent set of data for sd (equiv to \code{apply(dat,2,sd)}).
NAs are ignored from data.  Speed improvements may be seen at more than 100 columns
}
\examples{
set.seed(2016); dat1 <- matrix(c(runif(200) +rep(1:10,20)), ncol=10)
colSds(dat1)
}
\seealso{
\code{\link[stats]{sd}}
}
