% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowGrpMeans.R
\name{.rowGrpMeans}
\alias{.rowGrpMeans}
\title{row group mean (main)}
\usage{
.rowGrpMeans(x, grp, na.replVa = NULL, na.rm = TRUE)
}
\arguments{
\item{x}{numeric matrix where relplicates are organized into separate columns}

\item{grp}{(factor) defining which columns should be grouped (considered as replicates)}

\item{na.replVa}{(numeric) value to replace \code{NA} values}

\item{na.rm}{(logical) remove all \code{NA} values}
}
\value{
This function returns a matrix of mean values per row and group of replicates
}
\description{
This function calculates CVs for matrix with multiple groups of data, ie one CV for each group of data.
}
\examples{
set.seed(2016); dat1 <- matrix(c(runif(200)+rep(1:10,20)),ncol=10)
grp1 <- gl(4,3,labels=LETTERS[1:4])[2:11]
head(.rowGrpMeans(dat1, grp1))
}
\seealso{
\code{\link{rowGrpCV}}, \code{\link{rowCVs}}, \code{\link{arrayCV}}, \code{\link{replPlateCV}}
}
