% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineRedundLinesInList.R
\name{combineRedundLinesInList}
\alias{combineRedundLinesInList}
\title{Combine Redundant Lines In List}
\usage{
combineRedundLinesInList(
  lst,
  refNa = "ref",
  datNa = "quant",
  refColNa = "GeneName",
  supRefColNa = NULL,
  summarizeType = "av",
  NA.rm = TRUE,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{lst}{(list) main input, containing matrix or data.frame of numeric data (see \code{datNa} and annotation (see \code{refNa}) and possibly unrelated stuff}

\item{refNa}{(character) name of list-element containing annotation}

\item{datNa}{(character) name(s) of list-element(s) containing numeric/quantitation data}

\item{refColNa}{(character) in case the list-element to be used as reference is \code{matrix} or \code{data.frame}, the column to be used must be specified here}

\item{supRefColNa}{(character) in case the \code{lst$refNa} has no rownames, the content of column \code{lst$supRefColNa} will be used instead}

\item{summarizeType}{(character) the summarization method gets specified here; so far 'sum','av','med','first' and 'last' are implemented}

\item{NA.rm}{(logical) pass to summarizing functions order to omit \code{NA}s, defaults to \code{TRUE}}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a list of same length as input
}
\description{
This function provides help for combining/summarizing lines of numeric data which may be summaried according to reference vector or matrix of annotation (part of the same input-list).
The data and reference will be aligned and data corresponding to redundant information be combined/summarized.
}
\details{
All input data should be in a list, ie one or multipl matrix or data.frame for numeric data (see argument \code{datNa}), as well as the reference (see argument \code{refNa}). 
The refgerence may be a named character vecor or a matrix for which the column to be used should be specified using the argument \code{refColNa}.
In case the annotation is a matrix, the rownames will be used as unique/independent identifyers to adjust potentially different order of numeric data and annotation.
In absence of rownames, an additional column  \code{supRefColNa} of the annotation may be designed for adjusting the order of annotation and numeric data.
 
The numeric list may contain multiple matrixes or data.frames which will all be summarized by the same procedure as long as they have the same initial dimensions and are specified by \code{refNa}. 

Please note that all other list elements from input not specified by \code{refNa} (or \code{datNa}) will be maintained in the output just as they are.
}
\examples{
x1 <- list(quant=matrix(11:34, ncol=3, dimnames=list(letters[8:1], LETTERS[11:13])), 
  annot=matrix(paste0(LETTERS[c(1:4,6,3:5)],LETTERS[c(1:4,6,3:5)]), ncol=1, 
  dimnames=list(paste(letters[1:8]),"xx")) )
combineRedundLinesInList(lst=x1, refNa="annot", datNa="quant", refColNa="xx")
}
\seealso{
\code{\link{findRepeated}}, \code{\link{firstOfRepLines}}, \code{\link{organizeAsListOfRepl}}, \code{\link{combineRedBasedOnCol}}
}
