% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trimRedundText.R
\name{trimRedundText}
\alias{trimRedundText}
\title{Trim redundant text}
\usage{
trimRedundText(
  txt,
  minNchar = 1,
  side = "both",
  spaceElim = FALSE,
  silent = TRUE,
  callFrom = NULL,
  debug = FALSE
)
}
\arguments{
\item{txt}{character vector to be treated}

\item{minNchar}{(integer) minumin number of characters that must remain}

\item{side}{(character) may be be either 'both', 'left' or 'right'}

\item{spaceElim}{(logical) optional removal of any heading or tailing white space}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of messages produced}

\item{debug}{(logical) display additional messages for debugging}
}
\value{
This function returns a modified character vector
}
\description{
This function allows trimming/removing redundant text-fragments (redundant from head or tail) out of character vector 'txt'.
}
\examples{
txt1 <- c("abcd_ccc","bcd_ccc","cde_ccc")
trimRedundText(txt1, side="right")       # trim from right

txt2 <- c("ddd_ab","ddd_bcd","ddd_cde")
trimRedundText(txt2, side="left")        # trim from left 
}
\seealso{
Inverse : Find/keep common text \code{\link{keepCommonText}}; \code{\link{checkUnitPrefix}}; 
   you may also look for related functions in package \href{https://CRAN.R-project.org/package=stringr}{stringr}
}
