% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniqCountReport.R
\name{.plotCountPie}
\alias{.plotCountPie}
\title{Pie plot for counting results}
\usage{
.plotCountPie(
  count,
  tit = NULL,
  col = NULL,
  radius = 0.9,
  sizeTo = NULL,
  clockwise = FALSE,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{count}{(integer vector) counting result}

\item{tit}{(character) optional title in plot}

\item{col}{(character) custom colors in pie}

\item{radius}{(numeric) radius passed to  \code{pie}}

\item{sizeTo}{(numeric or charcter) optional reference group for size-population relative adjusting overall surface of pie}

\item{clockwise}{(logical) argument passed to pie}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
vector with counts of n (total), nUnique (wo any repeated), nHasRepeated (first of repeated), nRedundant), optional figure
}
\description{
This function allows to inspect results of \code{table} or \code{uniqCountReport} on a pie-plot
Note : fairly slow for long vectors !!
}
\examples{
.plotCountPie(table(c(1:5,4:2)))
}
\seealso{
\code{\link{uniqCountReport}}, \code{\link{correctToUnique}}, \code{\link[base]{unique}}
}
