% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizeThis.R
\name{.normalize}
\alias{.normalize}
\title{Main Normalization function}
\usage{
.normalize(
  dat,
  meth,
  mode,
  param,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{dat}{matrix or data.frame of data to get normalized}

\item{meth}{(character) may be "mean","median","NULL","none", "trimMean", "rowNormalize", "slope", "exponent", "slope2Sections", "vsn"; When \code{NULL} or 'none' is chosen the input will be returned}

\item{mode}{(character) may be "proportional", "additive";
decide if normalizatio factors will be applies as multiplicative (proportional) or additive; for log2-omics data \code{mode="aditive"} is suggested}

\item{param}{(list) additional parameters}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allows easier tracking of messages produced}
}
\value{
This function returns a numeric vector
}
\description{
This function aims to normalize a matrix or data.frame by columns. 
It assumes all checks have been done before calling this function.
}
\examples{
aa <- matrix(1:12, ncol=3)
.normalize(aa,"median",mode="proportional",param=NULL)
}
\seealso{
\code{\link{normalizeThis}}
}
