% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sortBy2CategorAnd1intCol.R
\name{sortBy2CategorAnd1IntCol}
\alias{sortBy2CategorAnd1IntCol}
\title{Sort matrix by two categorical and one integer columns}
\usage{
sortBy2CategorAnd1IntCol(mat, categCol, numCol, findNeighb = TRUE,
  decreasing = FALSE, silent = FALSE, callFrom = NULL)
}
\arguments{
\item{mat}{matrix (or data.frame) from which by 2 columns will be selected for sorting}

\item{categCol}{(integer or character) which columns of 'mat' to be used as categorical columns}

\item{numCol}{(integer or character) which column of 'mat' to be used as integer columns}

\item{findNeighb}{(logical) if 'findNeighb' neighbour cols according to 'numCol' will be identified as groups & marked in new col 'neiGr', orphans marked as NA}

\item{decreasing}{(logical) order of sort}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
sorted matrix (same dimensions as 'mat')
}
\description{
\code{sortBy2CategorAnd1IntCol} sorts matrix 'mat' subsequently by categorical and numerical columns of 'mat',
 ie lines with identical values for categor are sorted by numeric value.
}
\examples{
mat <- cbind(aa=letters[c(3,rep(7:8,3:4),4,4:6,7)],bb=LETTERS[rep(1:5,c(1,3,4,4,1))],
  nu=c(23:21,23,21,22,18:12))
mat[c(3:5,1:2,6:9,13:10),]
sortBy2CategorAnd1IntCol(mat,cate=c("bb","aa"),num="nu",findN=FALSE,decr=TRUE)
sortBy2CategorAnd1IntCol(mat,cate=c("bb","aa"),num="nu",findN=TRUE,decr=FALSE)
}
