% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partialDist.R
\name{partialDist}
\alias{partialDist}
\title{Partial distance matrix (focus on closest)}
\usage{
partialDist(dat, groups, overLap = TRUE, method = "euclidean",
  silent = FALSE, callFrom = NULL)
}
\arguments{
\item{dat}{(matrix of numeric values) main input}

\item{groups}{(factor) to split using \code{cut} or specific custom grouping (length of dat)}

\item{overLap}{(logical) if TRUE make groups overlapping by 1 value (ie maintain some context-information)}

\item{method}{'character' name of method passed to \code{dist}}

\item{silent}{(logical) suppres messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
matrix (not of class 'dist')
}
\description{
\code{partialDist} calculates distance matrix like \code{dist} for 1- or 2-dim data, but only partially, ie only cases of small distances.
This function was made for treating very large data-sets where only very close distances to a given point need to be found,
it allows to overcome memory-problems with larger data (and faster execution with > 50 rows of 'dat').
}
\examples{
set.seed(2016); mat3 <- matrix(runif(300),nr=30)
round(dist(mat3),1)
round(partialDist(mat3,gr=3),1)
}
\seealso{
\code{\link[stats]{dist}}
}
