% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ljungbox.R
\name{LjungBox}
\alias{LjungBox}
\title{Ljung and Box Portmanteau Test}
\usage{
LjungBox(
  obj,
  lags = seq(5, 30, 5),
  order = 0,
  season = 1,
  squared.residuals = FALSE
)
}
\arguments{
\item{obj}{a univariate or multivariate series with class "numeric",
"matrix", "ts", or ("mts" "ts"). It can be also an object of fitted
time-series model with class "ar", "arima0", "Arima", ("ARIMA forecast
ARIMA Arima"), "lm", ("glm" "lm"), or "varest". obj may also an object with
class "list" (see details and following examples).}

\item{lags}{vector of lag auto-cross correlation coefficients used for
\code{Hosking} test.}

\item{order}{Default is zero for testing the randomness of a given sequence
with class "numeric", "matrix", "ts", or ("mts" "ts"). In general order
equals to the number of estimated parameters in the fitted model. If obj is
an object with class "ar", "arima0", "Arima", "varest", ("ARIMA forecast
ARIMA Arima"), or "list" then no need to enter the value of order as it
will be automatically determined. For obj with other classes, the order is
needed for degrees of freedom of asymptotic chi-square distribution.}

\item{season}{seasonal periodicity for testing seasonality. Default is 1 for
testing the non seasonality cases.}

\item{squared.residuals}{if \code{TRUE} then apply the test on the squared values.
This checks for Autoregressive Conditional Heteroscedastic, \code{ARCH},
effects. When \code{squared.residuals = FALSE}, then apply the test on the usual
residuals.}
}
\value{
The Ljung and Box test statistic with the associated p-values for different
lags based on the asymptotic chi-square distribution with \code{k^2(lags-order)}
degrees of freedom.
}
\description{
The Ljung-Box (1978) modified portmanteau test. In the
multivariate time series, this test statistic is asymptotically equal to
\code{Hosking}.

This method and the bottom documentation is taken directly from the
original 'portes' package.
}
\details{
However the portmanteau test statistic can be applied directly on
the output objects from the built in R functions ar(), ar.ols(), ar.burg(),
ar.yw(), ar.mle(), arima(), arim0(), Arima(), auto.arima(), lm(), glm(),
and VAR(), it works with output objects from any fitted model. In this
case, users should write their own function to fit any model they want,
where they may use the built in R functions FitAR(), garch(), garchFit(),
fracdiff(), tar(), etc. The object obj represents the output of this
function. This output must be a list with at least two outcomes: the fitted
residual and the order of the fitted model (list(res = ..., order = ...)).
See the following example with the function FitModel().

Note: In stats R, the function Box.test was built to compute the Box and
Pierce (1970) and Ljung and Box (1978) test statistics only in the
univariate case where we can not use more than one single lag value at a
time. The functions BoxPierce and LjungBox are more accurate than Box.test
function and can be used in the univariate or multivariate time series at
vector of different lag values as well as they can be applied on an output
object from a fitted model described in the description of the function
BoxPierce.
}
\examples{
x <- rnorm(100)
LjungBox(x) # univariate test

x <- cbind(rnorm(100),rnorm(100))
LjungBox(x) # multivariate test

}
\references{
Ljung, G.M. and Box, G.E.P (1978). "On a Measure of Lack of Fit in Time
Series Models". Biometrika, 65, 297-303.
}
\author{
Esam Mahdi and A.I. McLeod
}
