% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_wpa.R
\name{import_wpa}
\alias{import_wpa}
\title{Import a Workplace Analytics Query}
\usage{
import_wpa(x, standardise = FALSE, encoding = "UTF-8")
}
\arguments{
\item{x}{String containing the path to the Workplace Analytics query to be
imported. The input file must be a CSV file, and the file extension must be
explicitly entered, e.g. \code{"/files/standard query.csv"}}

\item{standardise}{logical. If TRUE, \code{import_wpa()} runs \code{standardise_pq()}
to make a Collaboration Assessment query's columns name standard and
consistent with a Standard Person Query. Note that this will have no effect
if the query being imported is not a Ways of Working Assessment query.
Defaults as FALSE.}

\item{encoding}{String to specify encoding to be used within
\code{data.table::fread()}. See \code{data.table::fread()} documentation for more
information. Defaults to \code{'UTF-8'}.}
}
\value{
A \code{tibble} is returned.
}
\description{
Import a Workplace Analytics Query from a local CSV File, with variable
classifications optimised for other 'wpa' functions.
}
\details{
\code{import_wpa()} uses \code{data.table::fread()} to import CSV files for speed,
and by default \code{stringsAsFactors} is set to FALSE.
A data frame is returned by the function (not a \code{data.table}).
}
\seealso{
Other Import and Export: 
\code{\link{copy_df}()},
\code{\link{create_dt}()},
\code{\link{export}()},
\code{\link{import_to_fst}()},
\code{\link{standardise_pq}()}
}
\concept{Import and Export}
