% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_cooc.R
\name{tm_cooc}
\alias{tm_cooc}
\title{Analyse word co-occurrence in subject lines and return a network plot}
\usage{
tm_cooc(data, stopwords = NULL, seed = 100, return = "plot", lmult = 0.05)
}
\arguments{
\item{data}{A Meeting Query dataset in the form of a data frame.}

\item{stopwords}{A character vector OR a single-column data frame labelled
\code{'word'} containing custom stopwords to remove.}

\item{seed}{A numeric vector to set seed for random generation.}

\item{return}{String specifying what to return. This must be one of the
following strings:
\itemize{
\item \code{"plot"}
\item \code{"table"}
}

See \code{Value} for more information.}

\item{lmult}{A multiplier to adjust the line width in the output plot.
Defaults to 0.05.}
}
\value{
A different output is returned depending on the value passed to the \code{return}
argument:
\itemize{
\item \code{"plot"}: 'ggplot' and 'ggraph' object. A network plot.
\item \code{"table"}: data frame. A summary table.
}
}
\description{
This function generates a word co-occurrence network plot, with options to
return a table. This function is used within \code{meeting_tm_report()}.
}
\details{
This function uses \code{tm_clean()} as the underlying data wrangling function.
There is an option to remove stopwords by passing a data frame into the
\code{stopwords} argument.
}
\examples{
# Demo using a subset of `mt_data`
mt_data \%>\%
  dplyr::slice(1:20) \%>\%
  tm_cooc(lmult = 0.01)

}
\seealso{
Other Text-mining: 
\code{\link{meeting_tm_report}()},
\code{\link{pairwise_count}()},
\code{\link{subject_validate_report}()},
\code{\link{subject_validate}()},
\code{\link{tm_clean}()},
\code{\link{tm_freq}()},
\code{\link{tm_wordcloud}()}
}
\author{
Carlos Morales \href{mailto:carlos.morales@microsoft.com}{carlos.morales@microsoft.com}
}
\concept{Text-mining}
