# wpa <img src="https://raw.githubusercontent.com/microsoft/wpa/main/man/figures/logo2.png" align="right" width=15% />

  [![R build status](https://github.com/microsoft/wpa/workflows/R-CMD-check/badge.svg)](https://github.com/microsoft/wpa/actions/) [![CodeFactor](https://www.codefactor.io/repository/github/microsoft/wpa/badge/)](https://www.codefactor.io/repository/github/microsoft/wpa/) [![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT/) [![lifecycle](https://img.shields.io/badge/lifecycle-maturing-blue.svg)](https://lifecycle.r-lib.org/articles/stages.html)  [![CRAN status](https://www.r-pkg.org/badges/version/wpa)](https://CRAN.R-project.org/package=wpa)

## Analyze and Visualize Workplace Analytics data

This is an R package for analyzing and visualizing data from [Microsoft Workplace Analytics](https://docs.microsoft.com/en-us/workplace-analytics/).

## With the **wpa** package, you can...

1. **Run prebuilt analysis and visualizations** off Workplace Analytics data with settings for HR variables, privacy threshold, etc.

2. **Generate prebuilt interactive HTML reports**, which cover specific areas e.g. collaboration, connectivity 

3. Leverage **advanced analytics functions**, such as text mining and hierarchical clustering, which are built for Workplace Analytics metrics

4. Integrate analysis of Workplace Analytics data with your R workflow seamlessly

Here is an example of **wpa** in action:

<img src="https://raw.githubusercontent.com/microsoft/wpa/main/man/figures/output2.gif" align="center" width=80% />

---

## :rocket: Users

To get started with the package,  please see the following links: 

- [Installation and Set-up](https://microsoft.github.io/wpa/analyst_guide_getting_started.html)
- [Full function list](https://microsoft.github.io/wpa/reference/index.html)
- [Analyst Guide](https://microsoft.github.io/wpa/analyst_guide.html)
- [FAQ](https://microsoft.github.io/wpa/faq.html)
- [Microsoft Learn module](https://docs.microsoft.com/en-us/learn/modules/workplace-analytics-r-package/)

Also check out our package cheat sheet for a quick glimpse of what **wpa** offers:

<a href="https://github.com/microsoft/wpa/blob/main/man/figures/wpa%20cheatsheet.pdf"><img src="https://raw.githubusercontent.com/microsoft/wpa/main/man/figures/wpa%20cheatsheet.png" align="center" width=50% /></a>

---

## :hammer: Developers

We welcome contributions to the package! 

### Contributing code
If you would like contribute code to the repo, please read our [Contributor Guide](https://microsoft.github.io/wpa/CONTRIBUTING.html) and [Developer Guide](https://microsoft.github.io/wpa/developer_guide.html). This documentation should provide you all the information you will need to get started.

### Issues or Feature Requests
If you would like to log an issue or submit a feature request, please create a new issue or comment on an existing issue on [GitHub Issues](https://github.com/microsoft/wpa/issues) on this repo.

### Reporting Security Issues
Please do not report security vulnerabilities through public GitHub issues. Please read our Security document [for more details](https://microsoft.github.io/wpa/reporting_security_issues.html).

### Changelog
See [NEWS.md](https://microsoft.github.io/wpa/news/index.html) for the package changelog.

---

## Code of Conduct

We would ask you to please read the [Microsoft Open Source Code of Conduct](https://opensource.microsoft.com/codeofconduct/) prior to engaging with this package.


**Trademarks** 

This project may contain trademarks or logos for projects, products, or services. Authorized use of Microsoft trademarks or logos is subject to and must follow [Microsoft's Trademark & Brand Guidelines](https://www.microsoft.com/en-us/legal/intellectualproperty/trademarks/usage/general/). Use of Microsoft trademarks or logos in modified versions of this project must not cause confusion or imply Microsoft sponsorship. Any use of third-party trademarks or logos are subject to those third-party's policies.

---

## Finding this project useful? 

:star: Please star this repository to keep us going! 

Contributors to the GitHub repo:

![](https://raw.githubusercontent.com/microsoft/wpa/main/CONTRIBUTORS.svg)

See the full list of our contributors [here](https://microsoft.github.io/wpa/contributors.html).

