% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importNOAAlite.R
\name{importNOAAlite}
\alias{importNOAAlite}
\title{Import "Lite" Meteorological data from the NOAA Integrated Surface Database
(ISD)}
\usage{
importNOAAlite(code = "037720-99999", year = 2025, quiet = FALSE)
}
\arguments{
\item{code}{The identifying code as a character string. The code is a
combination of the USAF and the WBAN unique identifiers. The codes are
separated by a \dQuote{-} e.g. \code{code = "037720-99999"}.}

\item{year}{The year to import. This can be a vector of years e.g. \code{year = 2000:2005}.}

\item{quiet}{If \code{FALSE}, print missing sites / years to the screen, and show
a progress bar if multiple sites are imported.}
}
\value{
Returns a data frame of surface observations. The data frame is
consistent for use with the \code{openair} package. Note that the data are
returned in GMT (UTC) time zone format. Users may wish to express the data
in other time zones, e.g., to merge with air pollution data. The
\link[lubridate:lubridate-package]{lubridate} package is useful in this
respect.
}
\description{
This function is an alternative to \code{\link[=importNOAA]{importNOAA()}}, and provides access to the
"Lite" format of the data. This a subset of the larger \code{\link[=importNOAA]{importNOAA()}} dataset
featuring eight common climatological variables. As it assigns the nearest
measurement to the "top of the hour" to the data, specific values are likely
similar but different to those returned by \code{\link[=importNOAA]{importNOAA()}}. Read the
\href{https://www.ncei.noaa.gov/pub/data/noaa/isd-lite/isd-lite-technical-document.pdf}{technical document}
for more information.
}
\details{
Note the following units for the main variables:

\describe{

\item{date}{Date/time in POSIXct format. **Note the time zone is UTC
and may need to be adjusted to merge with other local data.}

\item{latitude}{Latitude in decimal degrees (-90 to 90).}

\item{longitude}{Longitude in decimal degrees (-180 to 180). Negative numbers
are west of the Greenwich Meridian.}

\item{elev}{Elevation of site in metres.}

\item{ws}{Wind speed in m/s.}

\item{wd}{Wind direction in degrees. 90 is from the east.}

\item{air_temp}{Air temperature in degrees Celcius.}

\item{atmos_pres}{The sea level pressure in millibars.}

\item{dew_point}{The dew point temperature in degrees Celcius.}

\item{precip_6}{6-hour precipitation in mm.}

\item{precip_1}{1-hour precipitation in mm.}

\item{sky}{Sky Condition Total Coverage Code.}
}

The data are returned in GMT (UTC). It may be necessary to adjust the time
zone when combining with other data. For example, if air quality data were
available for Beijing with time zone set to "Etc/GMT-8" (note the negative
offset even though Beijing is ahead of GMT. See the \code{openair} package and
manual for more details), then the time zone of the met data can be changed
to be the same. One way of doing this would be \code{attr(met$date, "tzone") <- "Etc/GMT-8"} for a meteorological data frame called \code{met}. The two data sets
could then be merged based on \code{date}.
}
\examples{

\dontrun{
heathrow_lite <- importNOAAlite(code = "037720-99999", year = 2025)
}
}
\seealso{
\code{\link[=getMeta]{getMeta()}} to obtain the codes based on various site search
approaches.

Other NOAA ISD functions: 
\code{\link{getMeta}()},
\code{\link{getMetaLive}()},
\code{\link{importNOAA}()}
}
\author{
Jack Davison
}
\concept{NOAA ISD functions}
