% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wflow_git_push.R
\name{wflow_git_push}
\alias{wflow_git_push}
\title{Push files to remote repository}
\usage{
wflow_git_push(remote = NULL, branch = NULL, username = NULL,
  password = NULL, force = FALSE, set_upstream = TRUE, view = TRUE,
  dry_run = FALSE, project = ".")
}
\arguments{
\item{remote}{character (default: NULL). The name of the remote repository.
See Details for the default behavior.}

\item{branch}{character (default: NULL). The name of the branch to push to in
the remote repository. If \code{NULL}, the name of the current local branch
is used.}

\item{username}{character (default: NULL). Username for online Git hosting
service (e.g. GitHub or GitLab). The user is prompted if necessary.}

\item{password}{character (default: NULL). Password for online Git hosting
service (e.g. GitHub or GitLab). The user is prompted if necessary.}

\item{force}{logical (default: FALSE). Force the push to the remote
repository. Do not use this if you are not 100\% sure of what it is doing.
Equivalent to: \code{git push -f}}

\item{set_upstream}{logical (default: TRUE). Set the current local branch to
track the remote branch if it isn't already tracking one. This is likely
what you want. Equivalent to: \code{git push -u remote branch}}

\item{view}{logical (default: TRUE). Open the URL to the repository in the
browser. Ignored if \code{dry_run = TRUE}. Also note that this only works
if the option \code{browser} is set, which you can check with
\code{getOption("browser")}.}

\item{dry_run}{logical (default: FALSE). Preview the proposed action but do
not actually push to the remote repository.}

\item{project}{character (default: ".") By default the function assumes the
current working directory is within the project. If this is not true,
you'll need to provide the path to the project directory.}
}
\value{
An object of class \code{wflow_git_push}, which is a list with the
  following elements:

\itemize{

\item \bold{remote}: The remote repository.

\item \bold{branch}: The branch of the remote repository.

\item \bold{username}: Username for online Git hosting service (e.g. GitHub
or GitLab).

\item \bold{force}: The input argument \code{force}.

\item \bold{set_upstream}: The input argument \code{set_upstream}.

\item \bold{view}: The input argument \code{view}.

\item \bold{dry_run}: The input argument \code{dry_run}.

\item \bold{protocol}: The authentication protocol for the remote repository
(either \code{"https"} or \code{"ssh"}.

}
}
\description{
\code{wflow_git_push} pushes the local files on your machine to your remote
repository on a remote Git hosting service (e.g. GitHub or GitLab). This is a
convenience function to run Git commands from the R console instead of the
Terminal. The same functionality can be achieved by running \code{git push}
in the Terminal.
}
\details{
\code{wflow_git_push} tries to choose sensible defaults if the user does not
explicitly specify the remote repository and/or the remote branch:

\itemize{

\item If both \code{remote} and \code{branch} are \code{NULL},
\code{wflow_git_push} checks to see if the current local branch is tracking a
remote branch. If yes, it pushes to this tracked remote branch.

\item If the argument \code{remote} is left as \code{NULL} and there is only
one remote, it is used.  If there is more than one remote, the one named
"origin" is used.

\item If the argument \code{branch} is left as \code{NULL}, the
name of the current local branch is used (referred to as \code{HEAD} by Git).

}

Under the hood, \code{wflow_git_push} is a wrapper for \code{\link[git2r]{push}}
from the package \link{git2r}.
}
\examples{
\dontrun{

# Push to remote repository
wflow_git_push()
# Preview by running in dry run mode
wflow_git_push(dry_run = TRUE)
}

}
