% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word2vec.R
\name{write.word2vec}
\alias{write.word2vec}
\title{Save a word2vec model to disk}
\usage{
write.word2vec(x, file, type = c("bin", "txt"))
}
\arguments{
\item{x}{an object of class \code{w2v} or \code{w2v_trained} as returned by \code{\link{word2vec}}}

\item{file}{the path to the file where to store the model}

\item{type}{either 'bin' or 'txt' to write respectively the file as binary or as a text file. Defaults to 'bin'.}
}
\value{
a logical indicating if the save process succeeded
}
\description{
Save a word2vec model as a binary file to disk or as a text file
}
\examples{
path  <- system.file(package = "word2vec", "models", "example.bin")
model <- read.word2vec(path)


## Save the model to hard disk as a binary file
path <- "mymodel.bin"
\dontshow{
path <- tempfile(pattern = "w2v", fileext = ".bin")
}
write.word2vec(model, file = path)
\dontshow{
file.remove(path)
}
## Save the model to hard disk as a text file (uses package udpipe)
library(udpipe)
path <- "mymodel.txt"
\dontshow{
path <- tempfile(pattern = "w2v", fileext = ".txt")
}
write.word2vec(model, file = path, type = "txt")
\dontshow{
file.remove(path)
}
}
\seealso{
\code{\link{word2vec}}
}
