% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github.R
\name{git_ignore}
\alias{git_ignore}
\title{Modify .gitignore file}
\usage{
git_ignore(..., ignore = TRUE, repo = ".")
}
\arguments{
\item{...}{Any number of character arguments, representing files to be added
to the .gitignore file.}

\item{ignore}{Logical. Whether or not 'Git' should ignore these files.}

\item{repo}{a path to an existing repository, or a git_repository object as
returned by git_open, git_init or git_clone.}
}
\value{
No return value. This function is called for its side effects.
}
\description{
Arguments passed through \code{...} are added to the .gitignore
file. Elements already present in the file are modified.
When \code{ignore = TRUE}, the arguments are added to the .gitignore file,
which will cause 'Git' to not track them.

When \code{ignore = FALSE}, the arguments are prepended with \code{!},
This works as a "double negation", and will cause 'Git' to track the files.
}
\examples{
if(requireNamespace("withr", quietly = TRUE)){
withr::with_tempdir({
dir.create(".git")
git_ignore("ignorethis.file")
})
}

}
