% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{wkt_plot}
\alias{wkt_plot}
\alias{wkb_plot}
\alias{wksxp_plot}
\title{Plot well-known geometry vectors}
\usage{
wkt_plot(
  x,
  ...,
  asp = 1,
  bbox = NULL,
  xlab = "",
  ylab = "",
  rule = "evenodd",
  add = FALSE
)

wkb_plot(
  x,
  ...,
  asp = 1,
  bbox = NULL,
  xlab = "",
  ylab = "",
  rule = "evenodd",
  add = FALSE
)

wksxp_plot(
  x,
  ...,
  asp = 1,
  bbox = NULL,
  xlab = "",
  ylab = "",
  rule = "evenodd",
  add = FALSE
)
}
\arguments{
\item{x}{A \code{\link[=wkt]{wkt()}}, \code{\link[=wkb]{wkb()}}, or \code{\link[=wksxp]{wksxp()}} vector.}

\item{...}{Passed to plotting functions for features: \code{\link[graphics:points]{graphics::points()}}
for point and multipoint geometries, \code{\link[graphics:lines]{graphics::lines()}} for linestring
and multilinestring geometries, and \code{\link[graphics:polypath]{graphics::polypath()}} for polygon
and multipolygon geometries.}

\item{asp, xlab, ylab}{Passed to \code{\link[graphics:plot.default]{graphics::plot()}}}

\item{bbox}{The limits of the plot in the form returned by \code{\link[=wksxp_ranges]{wksxp_ranges()}}.}

\item{rule}{The rule to use for filling polygons (see \code{\link[graphics:polypath]{graphics::polypath()}})}

\item{add}{Should a new plot be created, or should \code{x} be added to the
existing plot?}
}
\value{
\code{x}, invisibly
}
\description{
These plot functions are intended to help debug geometry vectors,
and are not intended to be high-performance.
}
\examples{
wkt_plot("POINT (30 10)")

}
