library(wkb)
library(sp)
context("Conversion to and from WKB MultiLineString representations")

# create an object of class SpatialLines
l1 <- data.frame(x = c(1, 2, 3), y = c(3, 2, 2))
l1a <- data.frame(x = l1[, 1] + .05, y = l1[, 2] + .05)
l2 <- data.frame(x = c(1, 2, 3), y = c(1, 1.5, 1))
Sl1 <- Line(l1)
Sl1a <- Line(l1a)
Sl2 <- Line(l2)
S1 <- Lines(list(Sl1, Sl1a), ID = "1")
S2 <- Lines(list(Sl2), ID = "2")
refobj <- SpatialLines(list(S1, S2))

# create an AsIs list of little-endian WKB geometry representations of type MultiLineString
refwkb <- I(list(
  as.raw(c(0x01, 0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02,
           0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
           0x00, 0x00, 0xf0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
           0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
           0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
           0x00, 0x08, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
           0x01, 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0xcd, 0xcc,
           0xcc, 0xcc, 0xcc, 0xcc, 0xf0, 0x3f, 0x66, 0x66, 0x66, 0x66, 0x66,
           0x66, 0x08, 0x40, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x40,
           0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x40, 0x66, 0x66, 0x66,
           0x66, 0x66, 0x66, 0x08, 0x40, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
           0x00, 0x40)),
  as.raw(c(0x01, 0x05, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x02,
           0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
           0x00, 0x00, 0xf0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0,
           0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
           0x00, 0x00, 0x00, 0x00, 0xf8, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00,
           0x00, 0x08, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x3f))
))

# create an AsIs list of big-endian WKB geometry representations of type MultiLineString
refwkbbe <- I(list(
  as.raw(c(0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
           0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x03, 0x3f, 0xf0, 0x00, 0x00,
           0x00, 0x00, 0x00, 0x00, 0x40, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
           0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
           0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x08, 0x00, 0x00, 0x00,
           0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
           0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x03, 0x3f, 0xf0,
           0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcd, 0x40, 0x08, 0x66, 0x66, 0x66,
           0x66, 0x66, 0x66, 0x40, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
           0x40, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x40, 0x08, 0x66,
           0x66, 0x66, 0x66, 0x66, 0x66, 0x40, 0x00, 0x66, 0x66, 0x66, 0x66,
           0x66, 0x66)),
  as.raw(c(0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
           0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x03, 0x3f, 0xf0, 0x00, 0x00,
           0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,
           0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf8,
           0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x08, 0x00, 0x00, 0x00,
           0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00))
))

test_that("little-endian WKB MultiLineString representation converts to SpatialLines object", {
  # convert little-endian WKB MultiLineString representation to SpatialLines object
  obj <- readWKB(refwkb)

  # test
  expect_equal(obj, refobj)
})

test_that("SpatialLines object converts to little-endian WKB MultiLineString representation", {
  # convert SpatialLines object to little-endian WKB MultiLineString representation
  wkb <- writeWKB(refobj)

  # test
  expect_equal(wkb, refwkb)
})

test_that("big-endian WKB MultiLineString representation converts to SpatialLines object", {
  # convert big-endian WKB MultiLineString representation to SpatialLines object
  obj <- readWKB(refwkbbe)

  # test
  expect_equal(obj, refobj)
})

test_that("SpatialLines object converts to big-endian WKB MultiLineString representation", {
  # convert SpatialLines object to big-endian WKB MultiLineString representation
  wkbbe <- writeWKB(refobj, endian = "big")

  # test
  expect_equal(wkbbe, refwkbbe)
})
