% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grd-subset.R
\name{grd_cell}
\alias{grd_cell}
\alias{grd_cell_range}
\alias{grd_cell_rct}
\alias{grd_cell_rct.wk_grd_rct}
\alias{grd_cell_rct.wk_grd_xy}
\alias{grd_cell_xy}
\alias{grd_cell_xy.wk_grd_rct}
\alias{grd_cell_xy.wk_grd_xy}
\title{Grid cell operators}
\usage{
grd_cell(grid, point, ..., snap = grd_snap_next)

grd_cell_range(
  grid,
  bbox = wk_bbox(grid),
  ...,
  step = 1L,
  snap = grd_snap_next
)

grd_cell_rct(grid, i, j = NULL, ...)

\method{grd_cell_rct}{wk_grd_rct}(grid, i, j = NULL, ..., out_of_bounds = "keep")

\method{grd_cell_rct}{wk_grd_xy}(grid, i, j = NULL, ..., out_of_bounds = "keep")

grd_cell_xy(grid, i, j = NULL, ...)

\method{grd_cell_xy}{wk_grd_rct}(grid, i, j = NULL, ..., out_of_bounds = "keep")

\method{grd_cell_xy}{wk_grd_xy}(grid, i, j = NULL, ..., out_of_bounds = "keep")
}
\arguments{
\item{grid}{A \code{\link[=grd_xy]{grd_xy()}}, \code{\link[=grd_rct]{grd_rct()}}, or other object
implementing \verb{grd_*()} methods.}

\item{point}{A \link[=wk_handle]{handleable} of points.}

\item{...}{Unused}

\item{snap}{A function that transforms real-valued indices to integer
indices (e.g., \code{\link[=floor]{floor()}}, \code{\link[=ceiling]{ceiling()}}, or \code{\link[=round]{round()}}).
For \code{\link[=grd_cell_range]{grd_cell_range()}}, a \code{list()} with exactly two elements to be called
for the minimum and maximum index values, respectively.}

\item{bbox}{An \code{\link[=rct]{rct()}} object.}

\item{step}{The difference between adjascent indices in the output}

\item{i, j}{1-based index values. \code{i} indices correspond to decreasing
\code{y} values; \code{j} indices correspond to increasing \code{x} values.
Values outside the range \code{1:nrow|ncol(data)} will be censored to
\code{NA} including 0 and negative values.}

\item{out_of_bounds}{One of 'keep', 'censor', 'discard', or 'squish'}
}
\value{
\itemize{
\item \code{grd_cell()}: returns a \code{list(i, j)} of index values corresponding
to the input points and adjusted according to \code{snap}. Index values
will be outside \code{dim(grid)} for points outside \code{wk_bbox(grid)} including
negative values.
\item \code{grd_cell_range()} returns a slice describing the range of indices
in the \code{i} and \code{j} directions.
\item \code{grd_cell_rct()} returns a \code{\link[=rct]{rct()}} of the cell extent at \verb{i, j}.
\item \code{grd_cell_xy()} returns a \code{\link[=xy]{xy()}} of the cell center at \verb{i, j}.
}
}
\description{
Grid cell operators
}
\examples{
grid <- grd(nx = 3, ny = 2)
grd_cell(grid, xy(0.5, 0.5))
grd_cell_range(grid, grid$bbox)
grd_cell_rct(grid, 1, 1)
grd_cell_xy(grid, 1, 1)

}
