% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tempfile.R
\name{with_tempfile}
\alias{with_tempfile}
\alias{local_tempfile}
\title{Temporary files}
\usage{
with_tempfile(
  new,
  code,
  envir = parent.frame(),
  pattern = "file",
  tmpdir = tempdir(),
  fileext = ""
)

local_tempfile(
  new,
  envir = parent.frame(),
  pattern = "file",
  tmpdir = tempdir(),
  fileext = ""
)
}
\arguments{
\item{new}{\verb{[character vector]}\cr Names of temporary file handles to create.}

\item{code}{\code{[any]}\cr Code to execute in the temporary environment}

\item{envir}{\verb{[environment]}\cr Environment in which to define the temporary files.}

\item{pattern}{a non-empty character vector giving the initial part
    of the name.}

\item{tmpdir}{a non-empty character vector giving the directory name}

\item{fileext}{a non-empty character vector giving the file extension}
}
\value{
\code{[any]}\cr The results of the evaluation of the \code{code}
argument.
}
\description{
Temporarily create a tempfile, which is automatically removed afterwards.
}
\examples{
# check how big iris would be if written as csv vs RDS
with_tempfile("tf", {write.csv(iris, tf); file.size(tf)})
with_tempfile("tf", {saveRDS(iris, tf); file.size(tf)})
}
\seealso{
\code{\link{withr}} for examples
}
