% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file.R
\name{with_file}
\alias{with_file}
\alias{local_file}
\title{Files which delete themselves}
\usage{
with_file(file, code)

local_file(file, .local_envir = parent.frame())
}
\arguments{
\item{file}{\verb{[named list]}\cr Files to create.}

\item{code}{\code{[any]}\cr Code to execute in the temporary environment}

\item{.local_envir}{\verb{[environment]}\cr The environment to use for scoping.}
}
\value{
\code{[any]}\cr The results of the evaluation of the \code{code}
argument.
}
\description{
Create files, which are then automatically removed afterwards.
}
\examples{
with_file("file1", {
  writeLines("foo", "file1")
  readLines("file1")
})

with_file(list("file1" = writeLines("foo", "file1")), {
  readLines("file1")
})
}
\seealso{
\code{\link{withr}} for examples
}
