% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/window_gd.R
\name{window_general}
\alias{window_general}
\title{General function for making moving window maps}
\usage{
window_general(
  x,
  coords,
  lyr,
  stat,
  wdim = 3,
  fact = 0,
  rarify = FALSE,
  rarify_n = NULL,
  rarify_nit = 5,
  min_n = 2,
  fun = mean,
  L = "nvariants",
  rarify_alleles = TRUE,
  sig = 0.05,
  crop_edges = FALSE,
  ...
)
}
\arguments{
\item{x}{data to be summarized by the moving window (\emph{note:} order matters! \code{coords} should be in the same order, there are currently no checks for this). The class of \code{x} required depends on the statistic being calculated (see the \code{stat} argument and the function description for more details)}

\item{coords}{coordinates of samples as sf points, a two-column matrix, or a data.frame representing x and y coordinates (see Details for important information about projections)}

\item{lyr}{SpatRaster or RasterLayer to slide the window across (see Details for important information about projections)}

\item{stat}{moving window statistic to calculate (can either be \code{"pi"} for nucleotide diversity (\code{x} must be a dosage matrix), \code{"Ho"} for average observed heterozygosity across all loci (\code{x} must be a heterozygosity matrix) , \code{"allelic_richness"} for average allelic richness across all loci (\code{x} must be a \code{genind} type object), \code{"biallelic_richness"} to get average allelic richness across all loci for a biallelic dataset (\code{x} must be a dosage matrix). \code{stat} can also be set to any function that will take \code{x}as input and return a single numeric value (for example, \code{x} can be a vector and \code{stat} can be set equal to a summary statistic like \code{mean}, \code{sum}, or \code{sd})}

\item{wdim}{dimensions (height x width) of window; if only one value is provided, a square window is created (defaults to 3 x 3 window)}

\item{fact}{aggregation factor to apply to \code{lyr} (defaults to 0; \emph{note:} increasing this value reduces computational time)}

\item{rarify}{if rarify = TRUE, rarefaction is performed (defaults to FALSE)}

\item{rarify_n}{if rarify = TRUE, number of points to use for rarefaction (defaults to min_n)}

\item{rarify_nit}{if rarify = TRUE, number of iterations to use for rarefaction (defaults to 5). Can also be set to \code{"all"} to use all possible combinations of samples of size \code{rarify_n} within the window.}

\item{min_n}{minimum number of samples to use in calculations (any focal cell with a window containing less than this number of samples will be assigned a value of NA; defaults to 2)}

\item{fun}{function to use to summarize rarefaction results (defaults to mean, must take \code{na.rm = TRUE} as an argument)}

\item{L}{for calculating \code{"pi"}, L argument in \link[hierfstat]{pi.dosage} function. Return the average nucleotide diversity per nucleotide given the length L of the sequence. The wingen default is L = "nvariants" which sets L to the number of variants in the VCF. If L = NULL, returns the sum over SNPs of nucleotide diversity (\emph{note:} L = NULL is the \link[hierfstat]{pi.dosage} default which wingen does not use)}

\item{rarify_alleles}{for calculating \code{"biallelic_richness"}, whether to perform rarefaction of allele counts as in \link[hierfstat]{allelic.richness} (defaults to TRUE)}

\item{sig}{for calculating \code{"hwe"}, significance threshold (i.e., alpha level) to use for hardy-weinberg equilibrium tests (defaults to 0.05)}

\item{crop_edges}{whether to remove cells on the edge of the raster where the window is incomplete (defaults to FALSE)}

\item{...}{if a function is provided for \code{stat}, additional arguments to pass to the \code{stat} function (e.g. if \code{stat = mean}, users may want to set \code{na.rm = TRUE})}
}
\value{
SpatRaster that includes a raster layer of genetic diversity and a raster layer of the number of samples within the window for each cell
}
\description{
Generate a continuous raster map using moving windows. While \link[wingen]{window_gd} is
built specifically for making moving window maps of genetic diversity from vcfs,
\code{window_general} can be used to make moving window maps from different data inputs.
See details for how to format data inputs for different statistics.
}
\details{
To calculate genetic diversity statistics with the built in wingen functions, data must be formatted as such:
\itemize{
\item for \code{"pi"} or  \code{"biallelic_richness"}, \code{x} must be a dosage matrix with values of 0, 1, or 2
\item for \code{"Ho"}, \code{x} must be a heterozygosity matrix where values of 0 = homozygosity and values of 1 = heterozygosity
\item for \code{"allelic_richness"} or \verb{"hwe}, \code{x} must be a \code{genind} type object
\item for \code{"basic_stats"}, \code{x} must be a \code{hierfstat} type object
}

Otherwise, \code{stat} can be any function that takes a matrix or data frame and outputs a
single numeric value (e.g., a function that produces a custom diversity index);
however, this should be attempted with caution since this functionality has
not have been tested extensively and may produce errors.
}
