% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getStartValue.R
\name{getStartValue}
\alias{getStartValue}
\title{Calculate the start values for the to be passed to the optimizer.}
\usage{
getStartValue(x, distribution, w = rep(1, length(x)), ...)
}
\arguments{
\item{x}{Numeric vector of the data observations.}

\item{distribution}{String indicating which distribution to use.}

\item{w}{Numeric Vector of weights. This is assumed to be in the same order as \code{x}. Default is a vector of ones the same length as \code{x}.}

\item{...}{Currently ignored.}
}
\value{
Vector of estimated parameters for the distribution.
}
\description{
Calculate start values for \code{\link{weightedLikelihood}} or \code{\link{weightedDistribution}}.
}
\details{
This function is intended for internal purposes only and is called by \link{weightedLikelihood} and \link{weightedDistribution}.
The function calculates the weighted mean and weighted variance and performs a method of moments approach to obtain start values for the likelihood estimation.
}
\examples{

x <- rnorm(100,10,5)

getStartValue(x,'norm')
mean(x)
sd(x)


}
