% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wald_test_wildmeta.R
\name{Wald_test_cwb}
\alias{Wald_test_cwb}
\title{Calculate p-values with cluster wild bootstrapping for meta-regression
models.}
\usage{
Wald_test_cwb(
  full_model,
  constraints,
  R,
  cluster = NULL,
  auxiliary_dist = "Rademacher",
  adjust = "CR0",
  type = "CR0",
  test = "Naive-F",
  seed = NULL,
  future_args = NULL
)
}
\arguments{
\item{full_model}{Model fit using \code{robumeta::robu()},
\code{metafor::rma.mv()}, or \code{metafor::rma.uni()} that includes the full set of moderators in the
meta-regression model.}

\item{constraints}{A q X p constraint matrix be tested. Alternately, a
function to create such a matrix, specified using
\code{clubSandwich::constrain_equal()} or
\code{clubSandwich::constrain_zero()}.}

\item{R}{Number of bootstrap replications.}

\item{cluster}{Vector of identifiers indicating which observations
belong to the same cluster. If \code{NULL} (the default), then the
clustering variable will be inferred based on the structure of
\code{full_mod}.}

\item{auxiliary_dist}{Character string indicating the auxiliary distribution
to be used for cluster wild bootstrapping, with available options:
"Rademacher", "Mammen", "Webb six", "uniform", "standard normal". The
default is set to "Rademacher." We recommend the Rademacher distribution
for models that have at least 10 clusters. For models with less than 10
clusters, we recommend the use of "Webb six" distribution.}

\item{adjust}{Character string specifying which small-sample adjustment
should be used to multiply the residuals by. The available options are
\code{"CRO"}, \code{"CR1"}, \code{"CR2"}, \code{"CR3"}, or \code{"CR4"},
with a default of \code{"CRO"}.}

\item{type}{Character string specifying which small-sample adjustment is used
to calculate the Wald test statistic. The available options are
\code{"CRO"}, \code{"CR1"}, \code{"CR2"}, \code{"CR3"}, or \code{"CR4"},
with a default of \code{"CRO"}.}

\item{test}{Character string specifying which (if any) small-sample
adjustment is used in calculating the test statistic. Default is
\code{"Naive-F"}, which does not make any small-sample adjustment.}

\item{seed}{Optional seed value to ensure reproducibility.}

\item{future_args}{Optional list of additional arguments passed to the
\code{future_*()} functions used in calculating results across bootstrap
replications. Ignored if the future.apply package is not available.}
}
\value{
A \code{data.frame} containing the name of the test, the adjustment
used for the bootstrap process, the type of variance-covariance matrix
used, the type of test statistic, the number of bootstrap replicates, and
the bootstrapped p-value.
}
\description{
Calculate p-values for single coefficient and multiple contrast
hypothesis tests using cluster wild bootstrapping.
}
\examples{
library(clubSandwich)
library(robumeta)

model <- robu(d ~ 0 + study_type + hrs + test,
             studynum = study,
              var.eff.size = V,
              small = FALSE,
              data = SATcoaching)

C_mat <- constrain_equal(1:3, coefs = coef(model))

Wald_test_cwb(full_model = model,
              constraints = C_mat,
              R = 12)

# Equivalent, using constrain_equal()
Wald_test_cwb(full_model = model,
              constraints = constrain_equal(1:3),
              R = 12)

}
