% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conTimelag.R
\name{conTimelag}
\alias{conTimelag}
\title{Compute time-lags from contact phases}
\usage{
conTimelag(traj, def = "all")
}
\arguments{
\item{traj}{an object of the class \code{move2} which should be output from the function \code{conPhase}.}

\item{def}{how to define the point-of-contact. The default is to define it as all fixes in a phase \code{def = 'all'}, alternatively contacts can be defined as a single point along the phase defined as one of: \code{'first','last','minDist','minTime'}, which corresponds to the first fix int he contact phase, the last fix in the contact phase, the fix with the minimum time difference and the fix with the closest contact distance.}
}
\value{
A move2 object with an additional column contact_timelag with the time to the nearest (in time) contact phase. Negative values indicate times prior to the nearest contact phase and postive values indicate times after the nearest contact phase. If an individual has no contacts, the contact time-lag is NA.
}
\description{
Computes the time-lag from the nearest contact phase.
}
\details{
This function is used following the \code{conphase} function. One should choose how to define the contact point (i.e., the parameter \code{contact}) depending on the research question.
}
\examples{

\dontrun{
data(does)
doecons <- conProcess(does,tc=15*60,dc=50)
doephas <- conPhase(doecons,pc=60*60)
conTL_first <- conTimelag(doephas,def='first')
conTL_all <- conTimelag(doephas,def='all')
}

}
\references{
Long, JA, Webb, SL, Harju, SM, Gee, KL (2022) Analyzing Contacts and Behavior from High Frequency 
 Tracking Data Using the wildlifeDI R Package. \emph{Geographical Analysis}. \bold{54}, 648--663.
}
\seealso{
conPhase, conProcess, conDisplacement
}
\keyword{contacts}
