% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prox.R
\name{Prox}
\alias{Prox}
\title{Proximity Index}
\usage{
Prox(traj1, traj2, tc = 0, dc = 50, local = FALSE,
  GetSimultaneous = TRUE)
}
\arguments{
\item{traj1}{an object of the class \code{ltraj} which contains the time-stamped
movement fixes of the first object. Note this object must be a \code{type II
ltraj} object. For more information on objects of this type see \code{help(ltraj)}.}

\item{traj2}{same as \code{traj1}.}

\item{tc}{time threshold for determining simultaneous fixes -- see function: \code{GetSimultaneous}.}

\item{dc}{distance tolerance limit (in appropriate units) for defining when 
two fixes are spatially together.}

\item{local}{logical value indicating whether or not a dataframe, containing the
distance between each simultaneous fix, should be returned.}

\item{GetSimultaneous}{logical value indicating whether proximity analysis is based on simultaneous fixes (if \code{TRUE} the default) -- see function \code{GetSimultaneous} or (if \code{FALSE}) a one-way mapping from \code{traj1} to {traj2} is used.}
}
\value{
If \code{local=FALSE} (the default) Prox returns the numeric value of the Prox index.
If \code{local=TRUE} Prox returns a dataframe containing the date/times of \emph{all} simultaneous fixes from \code{traj1}, 
and in the case of \code{GetSimultaneous = FALSE} the time of the fixes that were deemed simultaneous in \code{traj2}.
If \code{GetSimultaneous = TRUE} (the default) the Prox considers only the simultaneous fixes, as defined in \code{GetSimultaneous}. If \code{FALSE} Prox considers all the fixes in \code{traj1} relative to \code{traj2}. The latter functionality is useful when the time between fixes for one trajectory (\code{traj1}) is  much shorter than the second trajectory.
}
\description{
The function \code{Prox} simply computes the proportion of (simultaneous) fixes that are proximal, based on some spatial
threshold -- \code{dc} (Bertrand et al. 1996). It also facilitates local-level proximity analysis
}
\details{
The function \code{Prox} can be used to test for the presence of attraction (via proximity) in wildlife telemetry data. Prox is simply the proportion of simultaneous fixes within the threshold distance -- \code{dc}. The local output (dataframe) can be useful for examining variation in proximity through time.
}
\examples{
data(deer)
deer37 <- deer[1]
deer38 <- deer[2]
#tc = 7.5 minutes, dc = 50 meters
Prox(deer37, deer38, tc=7.5*60, dc=50)
df <- Prox(deer37, deer38, tc=7.5*60, dc=50, local=TRUE)

}
\references{
Bertrand, M.R., DeNicola, A.J., Beissinger, S.R, Swihart, R.K. (1996) Effects of parturition
on home ranges and social affiliations of female white-tailed deer.
\emph{Journal of Wildlife Management}, \bold{60}: 899-909.
}
\seealso{
GetSimultaneous, contacts
}
\keyword{indices}
