% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wikisource_page.R
\name{wikisource_page}
\alias{wikisource_page}
\title{Download a page from Wikisource}
\usage{
wikisource_page(wikiurl, page = NA)
}
\arguments{
\item{wikiurl}{The url of a Wikisource page that will
be downloaded.}

\item{page}{A string naming the Wikisource page downloaded.}
}
\value{
A four column tbl_df (a type of data frame; see tibble or
dplyr packages) with one row for each line of the text or texts,
with four columns.

\describe{
  \item{text}{A character column}
  \item{page}{A column naming the page downloaded}
  \item{language}{A character column with a two letter string refering
  to the language of the text}
  \item{url}{A character column with the url of the Wikisource page
  of the text}
}
}
\description{
Download the text of a Wikisource page into a data frame using its url.
}
\examples{

\dontrun{
# download Sonnet 18 of Shakespeare
wikisource_page("https://en.wikisource.org/wiki/Sonnet_18_(Shakespeare)", page = "Sonnet 18")

# download Sonnets 116, 73 and 130 of Shakespeare
library(purrr)

urls <- paste0("https://en.wikisource.org/wiki/Sonnet_", c(116, 73, 130), "_(Shakespeare)")
sonnets <- map2_df(urls, paste0("Sonnet ", c(116, 73, 130)), wikisource_page)
}

}
