% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wikiTools.R
\name{get_template_for_maps}
\alias{get_template_for_maps}
\title{Create a drop-down vignette for nodes from different items (for maps).}
\usage{
get_template_for_maps(
  data,
  title = NULL,
  title2 = NULL,
  text = NULL,
  img = NULL,
  wiki = NULL,
  color = "#cbdefb",
  cex = 1
)
}
\arguments{
\item{data}{data frame which contains the data.}

\item{title}{column name which contains the first tittle of the vignette.}

\item{title2}{column name which contains the secondary title of the vignette.}

\item{text}{column name which contains the main text of the vignette.}

\item{img}{column name which contains the names of the image files.}

\item{wiki}{column name which contains the wiki URL for the vignette.}

\item{color}{color of the vignette's strip (It also could be a column name which contains colors).}

\item{cex}{number indicating the amount by which plotting text should be scaled relative to the default.}
}
\value{
a character vector of html formatted vignettes.
}
\description{
Create a drop-down vignette for nodes from different items (for maps).
}
\examples{
## Obtaining information in English Wikidata
\dontrun{
names <- c("William Shakespeare", "Pablo Picasso")
info <- getWikiData(names)
info$html <- get_template_for_maps(info, title="entityLabel", text="entityDescription")
}
}
\author{
Modesto Escobar, Department of Sociology and Communication, University of Salamanca. See \url{https://sociocav.usal.es/blog/modesto-escobar/}
}
