% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_gv100.R
\name{read_gv100}
\alias{read_gv100}
\title{Reads the DESTATIS GV100 Format}
\usage{
read_gv100(file, stzrt, version = NULL, lcl = locale(encoding = "iso-8859-1"))
}
\arguments{
\item{file}{path to file}

\item{stzrt}{integer to select the administrative level (see details)}

\item{version}{which GV100 version. If NULL the version is guessed based on the file name.}

\item{lcl}{a \code{readr::locale()} specifying the encoding of the file.}
}
\value{
a \code{data.frame}.
}
\description{
The GV100 format is used by DESTATIS to publish the German municipality register
}
\details{
The Gemeindeverzeichnis (municipality register) is published 
 in a fixed width file refered to as "GV1000 ASCII Format" by 
 DESTATIS. The register features the list of municipality and 
 higher order administrative units.  

There are two types of files: One feature the administrative 
information (\code{version="AD"}) and one with non-administrative 
(\code{version="NAD"}). If \code{version=NULL}, read_gv100() guess the 
type based on the file name. 

To select a particular administrative 
 unit use the stzrt argument (Satzart). For the 
 AD version, the following choices are possible: 

 10 - Länder (states)
 20 - Regierungsbezirke 
 30 - Regionsdaten (only Baden-Württemberg)
 40 - Kreise (counties)
 50 - Gemeindeverbandsdaten 
 60 - Gemeinden (municipalities)
 
For the NAD version only: 

	41 - Kreise (counties)
 61 - Gemeinden (municipalities)
}
\examples{
 \dontrun{
  
		d <- read_gv100("GV100NAD31122016.asc", stzrt=60)

  }



}
\seealso{
\url{https://www.destatis.de/DE/Themen/Laender-Regionen/Regionales/Gemeindeverzeichnis/_inhalt.html}
\code{\link[readr]{read_fwf}} and \code{\link[readr]{locale}}
}
