% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_indicator.R
\name{helper_indicator}
\alias{helper_indicator}
\title{Create indicators from data frame}
\usage{
helper_indicator(
  df,
  vars_indicators,
  mapvalues_from,
  mapvalues_to,
  make_factor = TRUE
)
}
\arguments{
\item{df}{a data frame}

\item{vars_indicators}{a character vector of the variables from \code{df} to create indicators for}

\item{mapvalues_from}{vector to pass to \code{plyr::mapvalues()} argument \code{from}}

\item{mapvalues_to}{vector to pass to \code{plyr::mapvalues()} argument \code{to}}

\item{make_factor}{a logical indicating whether resulting indicators should be factors. Default is \code{TRUE}.}
}
\value{
a data frame with new columns that are the indicators from \code{vars_indicators}, with the same names pasted with \code{"_ind"}.
}
\description{
Create indicators from data frame
}
\examples{
helper_indicator(df = df_adults, 
vars_indicators = c("EF1", "EF2", "EF3"), 
mapvalues_from = 1:5, 
mapvalues_to = c(0,0,0,1,1))
}
