% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machine_learning.R
\name{wbt_random_forest_regression}
\alias{wbt_random_forest_regression}
\title{Random forest regression}
\usage{
wbt_random_forest_regression(
  inputs,
  training,
  field,
  output = NULL,
  n_trees = 100,
  min_samples_leaf = 1,
  min_samples_split = 2,
  test_proportion = 0.2,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{inputs}{Names of the input predictor rasters.}

\item{training}{Name of the input training site points shapefile.}

\item{field}{Name of the attribute containing response variable name data.}

\item{output}{Name of the output raster file. This parameter is optional. When unspecified, the tool will only build the model. When specified, the tool will use the built model and predictor rasters to perform a spatial prediction.}

\item{n_trees}{The number of trees in the forest.}

\item{min_samples_leaf}{The minimum number of samples required to be at a leaf node.}

\item{min_samples_split}{The minimum number of samples required to split an internal node.}

\item{test_proportion}{The proportion of the dataset to include in the test split; default is 0.2.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by WhiteboxTools to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Performs a random forest regression analysis using training site data and predictor rasters.
}
