% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream_network_analysis.R
\name{wbt_vector_stream_network_analysis}
\alias{wbt_vector_stream_network_analysis}
\title{Vector stream network analysis}
\usage{
wbt_vector_stream_network_analysis(
  streams,
  dem,
  output,
  cutting_height = 10,
  snap = 0.1,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{streams}{Name of the input streams vector file.}

\item{dem}{Name of the input DEM raster file.}

\item{output}{Name of the output lines shapefile.}

\item{cutting_height}{Maximum ridge-cutting height (z units).}

\item{snap}{Snap distance, in xy units (metres).}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by WhiteboxTools to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
This tool performs common stream network analysis operations on an input vector stream file.
}
