% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{welofit}
\alias{welofit}
\title{Calculates the WElo and Elo rates}
\usage{
welofit(
  x,
  W = "GAMES",
  SP = 1500,
  K = "Kovalchik",
  CI = FALSE,
  alpha = 0.05,
  B = 1000,
  new_data = NULL
)
}
\arguments{
\item{x}{Data cleaned through the function \code{\link{clean}} or, if the parameter 'new_data' is present,
a former estimated list coming from the \code{\link{welofit}} function}

\item{W}{\strong{optional} Weights to use for the WElo rating system. Valid choices are: "GAMES" (by default) and "SETS"}

\item{SP}{\strong{optional} Starting points for calculating the rates. 1500 by default}

\item{K}{\strong{optional} Scale factor determining how much the WElo and Elo rates change over time. Valid choices are:
"Kovalchik" (by default), "Grand_Slam", "Surface_Hard", "Surface_Grass", "Surface_Clay" and, finally, a constant value \eqn{K}.
The first option ("Kovalchik") is equal to what was suggested by \insertCite{kovalchik_2016;textual}{welo},
Putting \eqn{K} to "Grand_Slam" lets the Kovalchik scale factor multiplied by 1.1, if the match is a Grand Slam match.
Similarly, the choices "Surface_Hard", "Surface_Grass" and "Surface_Clay" make the Kovalchik scale factor
increased by 1.1 if, respectively, the match is played on hard, grass or clay. Finally, \eqn{K} can be any scalar value, indipendently of the number of matches played before the match \eqn{t}}

\item{CI}{\strong{optional} Confidence intervals for the WElo and Elo rates. Default to FALSE. If 'CI' is set to "TRUE", then the
confidence intervals are calculated, according to the procedure explained by \insertCite{angelini2021weighted;textual}{welo}}

\item{alpha}{\strong{optional} Significance level of the confidence interval. Default to 0.05}

\item{B}{\strong{optional} Number of bootstrap samples used to calculate the confidence intervals. Default to 1000}

\item{new_data}{\strong{optional} New data, cleaned through the function \code{\link{clean}}, to append to an already estimated set of matches (included
in the parameter 'x')}
}
\value{
\code{welofit} returns an object of class 'welo', which is a list containing the following components:
\itemize{
\item results: The data.frame including a variety of variables, among which there are the estimated WElo and Elo rates, before and
after the match \eqn{t}, for players \eqn{i} and \eqn{j},
the lower and upper confidence intervals (if CI=TRUE) for the WElo and Elo rates, labelled as '_lb' and '_ub', respectively, and the probability of winning the match for player \eqn{i} (labelled as 'WElo_pi_hat' and
'Elo_pi_hat', respectively, for the WElo and Elo models).
\item matches: The number of matches analyzed.
\item period: The sample period considered.
\item loss: The Brier score \insertCite{brier1950}{welo} and log-loss (used by  \insertCite{kovalchik_2016;textual}{welo}, among others)
averages, calculated considering the distance with respect to the outcome of the match.
\item highest_welo: The player with the highest WElo rate and the relative date.
\item highest_elo: The player with the highest Elo rate and the relative date.
\item dataset: The dataset used for the estimation of the WElo and Elo rates.
}
}
\description{
Calculates the WElo and Elo rates according to \insertCite{angelini2021weighted;textual}{welo}. In particular, the Elo updating system
defines the rates (for player \eqn{i}) as:
\deqn{E_{i}(t+1) = E_{i}(t) + K_i(t) \left[W_{i}(t)- \hat{p}_{i,j}(t) \right],}
where \eqn{E_{i}(t)} is the Elo rate at time \eqn{t}, \eqn{W_{i}(t)} is the outcome (1 or 0) for player \eqn{i} in the match at time \eqn{t},
\eqn{K_i(t)} is a scale factor, and \eqn{\hat{p}_{i,j}(t)} is the probability of winning for match at time \eqn{t}, calculated using \code{\link{tennis_prob}}.
The scale factor \eqn{K_i(t)} determines how much the rates change over time. By default, according to \insertCite{kovalchik_2016;textual}{welo}, it is defined as
\deqn{K_i(t)=250/\left(N_i(t)+5\right)^{0.4},}
where \eqn{N_i(t)} is the number of matches disputed by player \eqn{i} up to time \eqn{t}. Alternately, \eqn{K_i(t)} can be multiplied by 1.1 if
the match at time \eqn{t} is a Grand Slam match or is played on a given surface. Finally, it can be fixed to a constant value.
The WElo rating system is defined as:
\deqn{E_{i}^\ast(t+1) = E_{i}^\ast(t) + K_i(t) \left[W_{i}(t)- \hat{p}_{i,j}^\ast(t) \right] f(W_{i,j}(t)),}
where \eqn{E_{i}^\ast(t+1)} denotes the WElo rate for player \eqn{i}, \eqn{\hat{p}_{i,j}^\ast(t)} the probability of winning using \code{\link{tennis_prob}} and
the WElo rates, and \eqn{f(W_{i,j}(t))} represents a function whose values depend on the games (by default) or sets won in the previous match.
In particular, when parameter 'W' is set to "GAMES", \eqn{f(W_{i,j}(t))} is defined as:
\deqn{   f(W_{i,j}(t)) \equiv f(G_{i,j}(t))=  
\left\{
               \begin{array}{ll}
                \frac{NG_i(t)}{NG_i(t)+NG_j(t)} \quad if~player~i~has~won~match~t;\\
                 \frac{NG_j(t)}{NG_i(t)+NG_j(t)} \quad if~player~i~has~lost~match~t,
               \end{array}
            \right. 
}
where \eqn{NG_i(t)} and \eqn{NG_j(t)} represent the number of games won by player \eqn{i} and player \eqn{j} in match \eqn{t}, respectively.
When parameter 'W' is set to "SET", \eqn{f(W_{i,j}(t))} is:
\deqn{   f(W_{i,j}(t)) \equiv f(S_{i,j}(t))=  
\left\{
               \begin{array}{ll}
                \frac{NS_i(t)}{NS_i(t)+NS_j(t)} \quad if~player~i~has~won~match~t;\\
                 \frac{NS_j(t)}{NS_i(t)+NS_j(t)} \quad if~player~i~has~lost~match~t,
               \end{array}
            \right. 
}
where \eqn{NS_i(t)} and \eqn{NS_j(t)} represent the number of  sets won by player \eqn{i} and player \eqn{j} in match \eqn{t}, respectively.
The scale factor \eqn{K_i(t)} is the same as the Elo model.
}
\examples{
\donttest{
data(atp_2019) 
db_clean<-clean(atp_2019)
res<-welofit(db_clean)
# append new data
db_clean_1<-db_clean[1:500,]
db_clean_2<-db_clean[501:1200,]
res_1<-welofit(db_clean_1)
res_2<-welofit(res_1,new_data=db_clean_2)
}
}
\references{
\insertAllCited{}
}
