% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/welch-wrapper.R
\name{welchADF.test}
\alias{welchADF.test}
\alias{welchADF.test.formula}
\alias{welchADF.test.lm}
\alias{welchADF.test.aov}
\alias{welchADF.test.lmer}
\alias{welchADF.test.default}
\title{General Approximate Degrees of Freedom Solution for Inference and Estimation}
\usage{
welchADF.test(formula, ...)

\method{welchADF.test}{formula}(formula, data, subset, ...)

\method{welchADF.test}{lm}(formula, ...)

\method{welchADF.test}{aov}(formula, ...)

\method{welchADF.test}{lmer}(formula, ...)

\method{welchADF.test}{default}(formula, response, between.s, within.s = NULL,
  subject = NULL, contrast = c("omnibus", "all.pairwise"), effect = NULL,
  correction = c("hochberg", "holm"), trimming = FALSE, per = 0.2,
  bootstrap = FALSE, numsim_b = 999, effect.size = FALSE,
  numsim_es = 999, scaling = TRUE, standardize.effsz = TRUE,
  alpha = 0.05, seed = 0, ...)
}
\arguments{
\item{formula}{A data frame or a formula or an lm object returned by \code{\link[stats]{lm}}.
If \code{formula} is a data frame, it must have 
the format described for argument \code{data} of \code{welchADF.test} for class formula.
If \code{formula} is a formula, it must be a two-sided linear formula object describing the 
between-subjects effects of the model, with the response variable(s) (surrounded by \code{cbind()} 
if it is a multivariate response, as \code{cbind(r1, r2, r3)}) on the left of the ~ 
operator and the terms on the right. Within-subject factors must be specified as a parenthesis
term on the rhs with the form (w1*w2*...|subject) with 'subject' being the name of the 
subject ID column, which must be present in the data (cannot be omitted like in the data.frame version)
e.g. \code{cbind(y1,y2) ~ A*B*C + (B*C|subjet)}. In this example, A would be a between-subject
factor because it is the only variable not present again on the left side of the parenthesis term
(where the within-subjects factors are specified). Multi-level or customized structures are not supported, e.g.
those having strata or more than one random factor. The formula does not affect the results of the tests as 
no 'model' is actually fit to the data. It only affects the terms displayed as a result of an omnibus
contrast when no \code{effect} argument is given (which means \emph{run an omnibus test for every effect
or interaction (up to second order)}). In such case, the factors or interactions not specified in the formula
will not be applied an omnibus test. In case of a pairwise contrast, the structure in the formula is ignored
beyond interpreting which variables are between-subject factors and which are within-subjects factors.}

\item{...}{Further arguments to be passed to specialized methods. Should be named arguments.}

\item{data}{A data.frame with the data, formatted as follows: one row per 
observation of the response variable(s), and as many columns as needed to indicate the 
factor combination to which the observation corresponds. If necessary, an extra column with
the subject ID for designs having within-subjects factors
(can be omitted if there is only one within-subjects factor, see the vignette).}

\item{subset}{A specification of the rows to be used as in \code{\link[stats]{model.frame}}: defaults to all rows. 
This can be any valid indexing vector (see [.data.frame) for the rows of data 
or if that is not supplied, a data frame made up of the variables used in formula.}

\item{response}{A string or vector of strings with the name(s) of the column(s) of \code{data} corresponding to the response variable(s). If 
a vector of strings is provided, the responses are taken as a set of repeated measurements or dependent variables.}

\item{between.s}{Vector of strings with the columns that correspond to between-subjects factors.}

\item{within.s}{Vector of strings with the columns that correspond to within-subjects factors, if any (defaults to NULL).}

\item{subject}{Name of the column (if any) containing the subject ID (defaults to NULL).}

\item{contrast}{One of \code{"omnibus", "all.pairwise"} indicating the type of contrast to be performed with the data.
\code{"omnibus"} stands for omnibus contrasts on either all the variables found in the data, including the within-subjects factor if any,
or on a single effect specified in the \code{effect} argument.
\code{"all.pairwise"} stands for pairwise comparisons of the response(s) variable(s) over all combinations of values of one effect, indicated
 in the \code{effect} parameter.
Defaults to \code{"omnibus"}.}

\item{effect}{If \code{contrast = "omnibus"}, then \code{effect} must be a string or vector of strings with the name of the effect(s) for which the \code{"omnibus"} 
contrasts will be applied. 
If \code{contrast = "all.pairwise"}, then \code{effect} must be \emph{a tagged list} in which the names are the factors, and the elements must be vectors of two strings
each, indicating 
If \code{contrast = "omnibus"} but \code{effect} is not specified, then an omnibus contrast will be done separately for each of the effects and also all possible interactions.
If \code{contrast = "omnibus"} and \code{effect} is a vector of strings, then only \emph{one} contrast will be done, involving the simultaneous interaction of all effects
indicated in the \code{effect} vector (i.e. no other interaction or main effect contrasts will be performed).}

\item{correction}{The type of p-value correction when applying multiple pariwise comparisons (i.e. when \code{contrast = "all.pairwise"}). Defaults to "hochberg".}

\item{trimming}{Boolean to control the use of robust estimators. 
    \code{FALSE} indicates the ADF test statistic will be computed with the usual Least-Squares Estimators. 
\code{TRUE} indicates that trimmed means and Winsorized variances/covariances will be used to compute the ADF test statistic.}

\item{per}{(Only if trimming is TRUE) The proportion of trimming in EACH tail of the data distribution. Must be between 
0 and .49 (i.e., 49\% trimming in each tail). Recommended per = 0.2 symmetric trimming (i.e., 20\% of the observations in each tail are trimmed).}

\item{bootstrap}{Boolean; whether bootstrap should be used to compute a critical value for the test statistic produced by WJGLM. \code{FALSE} means a theoretical 
critical value for the test statistic TWJ/c (or TWJt/c) will be computed. \code{TRUE} indicates the non-parametric percentile bootstrap method 
will be used to compute a critical value. When combined with \code{contrast = "all.pairwise"}, then Family-Wise Error Rate (FWER) control is achieved using
bootstrapping to compute an adjusted empirical critical value (refer to Keselman, Wilcox & Lix 2003, page 589 for details).}

\item{numsim_b}{If \code{bootstrap = TRUE}, this is a positive integer that defines the number of bootstrap samples to generate a critical 
value (defaults to 999).  Carpenter and Bithell (2000) recommend between 1000 and 2000 samples for setting confidence intervals around a 
parameter estimate, but Efron and Tibshirani (1986) note that for other applications of the bootstrap, such as computing the standard error, as 
few as 100 bootstrap samples will be sufficient. Choosing a value of B such that (B + 1)\eqn{\alpha} is an integer value is recommended, because it 
avoids the need for interpolation.}

\item{effect.size}{Boolean; whether effect size estimates should be computed. \code{TRUE} means effect size estimates together with its confidence intervals 
will be computed (defaults to FALSE).}

\item{numsim_es}{Positive integer defining the number of bootstrap samples to generate a CI for the effect size estimate (defaults to 999). Ignored if \code{effect.size = FALSE}.}

\item{scaling}{Boolean; whether a scaling factor for the effect size estimator should be used (0.642 for 20\% symmetric trimming) when 
robust estimators are adopted. \code{FALSE} means no scaling factor will be used. \code{TRUE} indicates that a scaling factor will be adopted. Defaults to TRUE}

\item{standardize.effsz}{Boolean: whether the effect size should be standardized by the average of variances or not. Defaults to TRUE.}

\item{alpha}{Significance threshold for the confidence interval calculation, where 1 - \code{alpha} is the probability coverage. Defaults to 0.05.}

\item{seed}{Initial seed (positive integer) for the (R default) random number generator. Defaults to NULL (seed taken from the current time).}
}
\value{
An object of class "welchADFt" which is a list of lists (one sub-list per effect, even if there is only one).
  There are methods \code{\link[welchADF]{print.welchADFt}} and \code{\link[welchADF]{summary.welchADFt}}
}
\description{
Computes the Welch-James statistic with Approximate Degrees of Freedom, 
based on the SAS code by H.J. Keselman, R.R. Wilcox and L.M. Lix.
}
\section{Methods (by class)}{
\itemize{
\item \code{formula}: Specialized method that accepts a formula

\item \code{lm}: Specialized method that accepts a linear model object of class \code{\link[stats]{lm}}

\item \code{aov}: Specialized method that accepts an Analysis of Variance Model of class \code{\link[stats]{aov}}

\item \code{lmer}: Specialized method that accepts a Linear Mixed-Effects Model of class \code{\link[lme4]{lmer}}

\item \code{default}: Default method that accepts a data.frame (see argument \code{formula}) and where 
factors are passed as strings corresponding to column names
}}

\examples{
# Omnibus contrast only of those effects included, namely condition and sex (no interaction)
omnibus_LSM_formula <- welchADF.test(y ~ condition + sex, data = womenStereotypeData)
# Works well with update.default() method
omnibus_interact_formula <- update(omnibus_LSM_formula, . ~ condition*sex)
summary(omnibus_LSM_formula)
summary(omnibus_interact_formula)

# Fit a linear model using the built-in function stats::lm
lm.women <- lm(y ~ condition + sex, womenStereotypeData)

# Fit an Analysis of Variance model using the built-in function stats::aov
aov.women <- aov(lm.women)

# Now use the this object to apply a welchADF test to the same formula and data
omnibus_no_interact <- welchADF.test(lm.women, contrast = "omnibus")
omnibus_no_interactB <- welchADF.test(aov.women) # omnibus as well

# Integrates well with the update.default() method
omnibus_interact <- update(omnibus_no_interact, . ~ condition*sex)
summary(omnibus_no_interact)
summary(omnibus_interact)
# Two-way factorial design using the default interface. See the vignette.
omnibus_LSM <- welchADF.test(womenStereotypeData, response = "y", between.s = 
  c("condition", "sex"), contrast = "omnibus")
# Method update() also works with the welchADF.test.default interface
omnibus_trimmed <- update(omnibus_LSM, effect = "condition", trimming = TRUE)
pairwise_LSM <- update(omnibus_LSM, contrast = "all.pairwise", effect = c("condition", "sex"))
pairwise_trimmed <- update(pairwise_LSM, trimming = TRUE) # just trimming
pairwise_trimmed_boot <- update(pairwise_trimmed, bootstrap = TRUE) # trimming and bootstrapping
summary(omnibus_LSM)
pairwise_LSM
summary(pairwise_trimmed_boot)
}
\references{
Home page of Prof. Lisa M. Lix, author of the original SAS code: \url{http://homepage.usask.ca/~lml321/SAS_Programs.html}

Keselman, H. J., Wilcox, R. R., & Lix, L. M. (2003). A generally robust approach to hypothesis testing in independent and correlated groups designs. 
\emph{Psychophysiology}, 40, 586-596.

Lix, L. M., & Keselman, H. J. (1995). Approximate degrees of freedom tests: A unified perspective on testing for mean equality. 
\emph{Psychological Bulletin}, 117, 547-560.

Carpenter, J., & Bithell, J. (2000). Bootstrap confidence intervals: When, which, what? A practical guide for medical statisticians. 
\emph{Statistics in Medicine}, 19, 1141-1164.

Efron, B., & Tibshirani, R. (1986). Bootstrap methods for standard errors, confidence intervals, and other measures of statistical accuracy. 
\emph{Statistical Science}, 1, 54-75.
}
\seealso{
\code{\link[welchADF]{print.welchADFt}}, \code{\link[welchADF]{summary.welchADFt}}

\code{\link{p.adjust.methods}} 
  \code{\link{perceptionData}}
  \code{\link{adhdData}}
  \code{\link{adhdData2}}
  \code{\link{womenStereotypeData}}
  \code{\link{miceData}}
}
