% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_player.R
\name{wnba_playerestimatedmetrics}
\alias{wnba_playerestimatedmetrics}
\title{\strong{Get WNBA Stats API Player Estimated Metrics}}
\usage{
wnba_playerestimatedmetrics(
  league_id = "10",
  season = most_recent_wnba_season() - 1,
  season_type = "Regular Season",
  ...
)
}
\arguments{
\item{league_id}{League - default: '00'. Other options include '10': WWNBA, '20': G-League}

\item{season}{Season - format 2020-21}

\item{season_type}{Season Type - Regular Season, Playoffs, All-Star}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: PlayerEstimatedMetrics

\strong{PlayerEstimatedMetrics}\tabular{ll}{
   col_name \tab types \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   GP \tab character \cr
   W \tab character \cr
   L \tab character \cr
   W_PCT \tab character \cr
   MIN \tab character \cr
   E_OFF_RATING \tab character \cr
   E_DEF_RATING \tab character \cr
   E_NET_RATING \tab character \cr
   E_AST_RATIO \tab character \cr
   E_OREB_PCT \tab character \cr
   E_DREB_PCT \tab character \cr
   E_REB_PCT \tab character \cr
   E_TOV_PCT \tab character \cr
   E_USG_PCT \tab character \cr
   E_PACE \tab character \cr
   GP_RANK \tab character \cr
   W_RANK \tab character \cr
   L_RANK \tab character \cr
   W_PCT_RANK \tab character \cr
   MIN_RANK \tab character \cr
   E_OFF_RATING_RANK \tab character \cr
   E_DEF_RATING_RANK \tab character \cr
   E_NET_RATING_RANK \tab character \cr
   E_AST_RATIO_RANK \tab character \cr
   E_OREB_PCT_RANK \tab character \cr
   E_DREB_PCT_RANK \tab character \cr
   E_REB_PCT_RANK \tab character \cr
   E_TOV_PCT_RANK \tab character \cr
   E_USG_PCT_RANK \tab character \cr
   E_PACE_RANK \tab character \cr
}
}
\description{
\strong{Get WNBA Stats API Player Estimated Metrics}

\strong{Get WNBA Stats API Player Estimated Metrics}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{  wnba_playerestimatedmetrics()
}\if{html}{\out{</div>}}
}
\seealso{
Other WNBA Player Functions: 
\code{\link{wnba_infographicfanduelplayer}()},
\code{\link{wnba_leaguedashplayerbiostats}()},
\code{\link{wnba_leaguedashplayerclutch}()},
\code{\link{wnba_leaguedashplayershotlocations}()},
\code{\link{wnba_leaguedashplayerstats}()},
\code{\link{wnba_leagueplayerondetails}()},
\code{\link{wnba_leagueseasonmatchups}()},
\code{\link{wnba_playerawards}()},
\code{\link{wnba_playercareerbycollegerollup}()},
\code{\link{wnba_playercareerbycollege}()},
\code{\link{wnba_playercareerstats}()},
\code{\link{wnba_playercompare}()},
\code{\link{wnba_playerdashboardbyclutch}()},
\code{\link{wnba_playerdashboardbygamesplits}()},
\code{\link{wnba_playerdashboardbygeneralsplits}()},
\code{\link{wnba_playerdashboardbylastngames}()},
\code{\link{wnba_playerdashboardbyopponent}()},
\code{\link{wnba_playerdashboardbyshootingsplits}()},
\code{\link{wnba_playerdashboardbyteamperformance}()},
\code{\link{wnba_playerdashboardbyyearoveryear}()},
\code{\link{wnba_playerfantasyprofilebargraph}()},
\code{\link{wnba_playerfantasyprofile}()},
\code{\link{wnba_playergamelogs}()},
\code{\link{wnba_playergamelog}()},
\code{\link{wnba_playergamestreakfinder}()},
\code{\link{wnba_playerheadshot}()},
\code{\link{wnba_playerindex}()},
\code{\link{wnba_playernextngames}()},
\code{\link{wnba_playerprofilev2}()},
\code{\link{wnba_playervsplayer}()}
}
\author{
Saiem Gilani
}
\concept{WNBA Player Functions}
