% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_draft.R
\name{wnba_draftcombinestats}
\alias{wnba_draftcombinestats}
\title{\strong{Get WNBA Stats API Draft Combine Stats}}
\usage{
wnba_draftcombinestats(
  league_id = "10",
  season_year = most_recent_wnba_season() - 1,
  ...
)
}
\arguments{
\item{league_id}{league_id}

\item{season_year}{season_year}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: DraftCombineStats

\strong{DraftCombineStats}\tabular{ll}{
   col_name \tab types \cr
   SEASON \tab character \cr
   PLAYER_ID \tab character \cr
   FIRST_NAME \tab character \cr
   LAST_NAME \tab character \cr
   PLAYER_NAME \tab character \cr
   POSITION \tab character \cr
   HEIGHT_WO_SHOES \tab character \cr
   HEIGHT_WO_SHOES_FT_IN \tab character \cr
   HEIGHT_W_SHOES \tab character \cr
   HEIGHT_W_SHOES_FT_IN \tab character \cr
   WEIGHT \tab character \cr
   WINGSPAN \tab character \cr
   WINGSPAN_FT_IN \tab character \cr
   STANDING_REACH \tab character \cr
   STANDING_REACH_FT_IN \tab character \cr
   BODY_FAT_PCT \tab character \cr
   HAND_LENGTH \tab character \cr
   HAND_WIDTH \tab character \cr
   STANDING_VERTICAL_LEAP \tab character \cr
   MAX_VERTICAL_LEAP \tab character \cr
   LANE_AGILITY_TIME \tab character \cr
   MODIFIED_LANE_AGILITY_TIME \tab character \cr
   THREE_QUARTER_SPRINT \tab character \cr
   BENCH_PRESS \tab character \cr
   SPOT_FIFTEEN_CORNER_LEFT \tab character \cr
   SPOT_FIFTEEN_BREAK_LEFT \tab character \cr
   SPOT_FIFTEEN_TOP_KEY \tab character \cr
   SPOT_FIFTEEN_BREAK_RIGHT \tab character \cr
   SPOT_FIFTEEN_CORNER_RIGHT \tab character \cr
   SPOT_COLLEGE_CORNER_LEFT \tab character \cr
   SPOT_COLLEGE_BREAK_LEFT \tab character \cr
   SPOT_COLLEGE_TOP_KEY \tab character \cr
   SPOT_COLLEGE_BREAK_RIGHT \tab character \cr
   SPOT_COLLEGE_CORNER_RIGHT \tab character \cr
   SPOT_NBA_CORNER_LEFT \tab character \cr
   SPOT_NBA_BREAK_LEFT \tab character \cr
   SPOT_NBA_TOP_KEY \tab character \cr
   SPOT_NBA_BREAK_RIGHT \tab character \cr
   SPOT_NBA_CORNER_RIGHT \tab character \cr
   OFF_DRIB_FIFTEEN_BREAK_LEFT \tab character \cr
   OFF_DRIB_FIFTEEN_TOP_KEY \tab character \cr
   OFF_DRIB_FIFTEEN_BREAK_RIGHT \tab character \cr
   OFF_DRIB_COLLEGE_BREAK_LEFT \tab character \cr
   OFF_DRIB_COLLEGE_TOP_KEY \tab character \cr
   OFF_DRIB_COLLEGE_BREAK_RIGHT \tab character \cr
   ON_MOVE_FIFTEEN \tab character \cr
   ON_MOVE_COLLEGE \tab character \cr
}
}
\description{
\strong{Get WNBA Stats API Draft Combine Stats}

\strong{Get WNBA Stats API Draft Combine Stats}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{  wnba_draftcombinestats(season_year = most_recent_wnba_season() - 1)
}\if{html}{\out{</div>}}
}
\seealso{
Other WNBA Draft Functions: 
\code{\link{wnba_draftboard}()},
\code{\link{wnba_draftcombinedrillresults}()},
\code{\link{wnba_draftcombinenonstationaryshooting}()},
\code{\link{wnba_draftcombineplayeranthro}()},
\code{\link{wnba_draftcombinespotshooting}()},
\code{\link{wnba_drafthistory}()}
}
\author{
Saiem Gilani
}
\concept{WNBA Draft Functions}
