% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weco_rules.R
\name{weco.rule}
\alias{weco.rule}
\title{Individual WECO Rule}
\usage{
weco.rule(rule, x, sdx = sd(x), mux = mean(x), ...)
}
\arguments{
\item{rule}{WECO rule number from 1 to 8}

\item{x}{A vector of continuously observed data from some process}

\item{sdx}{Standard deviation of the observed data}

\item{mux}{Mean of the observed data}

\item{...}{Specifications for individual rule
\describe{
 \item{k}{Number of "abnormal" data points}
 \item{l}{Number of standard deviations}
 \item{n}{Number of data points prior to the current point
(including the current point) to be evaluated}}}
}
\value{
A class \code{weco} list contains the original data \code{x}, the mean,
    standard deviation, the rules, and a vector with the same length as \code{x} that
    contains the out of boundary status of each point
}
\description{
Apply individual WECO rules 1-8 to continuously observed data from some
process to detect abnormal signals. See \code{\link{weco-package}} for the
details of the eight WECO rules.
}
\examples{

x <- rnorm(1000);

## use empirical mean and standard deviation of x
rst.1 <- weco.rule(1, x, l=3);
rst.2 <- weco.rule(2, x, k=9);
rst.3 <- weco.rule(3, x, k=6);
rst.4 <- weco.rule(4, x, k=16);
rst.5 <- weco.rule(5, x, k=2, n=3, l=2);
rst.6 <- weco.rule(6, x, k=4, n=5, l=1);
rst.7 <- weco.rule(7, x, k=15, l=1);
rst.8 <- weco.rule(8, x, k=8, l=1);

## use given mean and standard deviation
rst.1 <- weco.rule(1, x, l=3, mux=0, sdx=1);

}
\seealso{
\code{\link{weco-package}}
}

