% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{classify_domains}
\alias{classify_domains}
\title{Classify domains according to prespecified classes}
\usage{
classify_domains(
  wt,
  domain_classes = NULL,
  prev_type = TRUE,
  preprocess_newsportals = FALSE,
  return.only = NULL
)
}
\arguments{
\item{wt}{webtrack data object}

\item{domain_classes}{a data.table containing a column "domain" and "type". If NULL, an internal list is used}

\item{prev_type}{logical. If TRUE (default) the type of the domain visited before the current visit is added}

\item{preprocess_newsportals}{logical. add suffix "NEWS" to domains which are classified as portals. If TRUE there needs to be a domain type "newsportals"}

\item{return.only}{if not null, only return the specified domain type}
}
\value{
webtrack data.table with the same columns as wt and a new column called type. If prev_type is TRUE, a column prev_type is added with the type of the visit before the current one. If newsportals are processed, found newsportals have an added "/NEWS" in the domain column. If return.only is used, only rows that contain a specific domain type are returned
}
\description{
Classify domains according to prespecified classes
}
\examples{
data("test_data")
wt <- as.wt_dt(test_data)
wt <- extract_domain(wt)
wt <- add_duration(wt)
wt <- classify_domains(wt)
}
