% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webqueue.r
\name{WebQueue}
\alias{WebQueue}
\title{Queues and Services HTTP Requests}
\description{
Connects the 'httpuv' and 'jobqueue' R packages.
}
\examples{
    
    library(webqueue)
    
    wq <- WebQueue$new(function (req) 'Hello World!\n')
    readLines(wq$url)
    wq$stop()

}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{url}}{URL where the server is available.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-WebQueue-new}{\code{WebQueue$new()}}
\item \href{#method-WebQueue-print}{\code{WebQueue$print()}}
\item \href{#method-WebQueue-stop}{\code{WebQueue$stop()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WebQueue-new"></a>}}
\if{latex}{\out{\hypertarget{method-WebQueue-new}{}}}
\subsection{Method \code{new()}}{
Creates an \code{httpuv::WebServer} with requests handled by a \code{jobqueue::Queue}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WebQueue$new(
  handler,
  host = "0.0.0.0",
  port = 8080L,
  parse = NULL,
  globals = list(),
  packages = NULL,
  namespace = NULL,
  init = NULL,
  max_cpus = availableCores(),
  workers = ceiling(max_cpus * 1.2),
  timeout = NULL,
  hooks = NULL,
  reformat = NULL,
  stop_id = NULL,
  copy_id = NULL,
  bg = TRUE,
  quiet = FALSE,
  onHeaders = NULL,
  staticPaths = NULL,
  staticPathOptions = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{handler}}{A \verb{function (request)} that will be run on a background
worker process. The returned value will be passed through
\code{reformat}, then sent as the server's response to the web client.}

\item{\code{host}}{A string that is a valid IPv4 address that is owned by this
server, or \code{'0.0.0.0'} to listen on all IP addresses.}

\item{\code{port}}{A number or integer that indicates the server port that should
be listened on. Note that on most Unix-like systems including Linux
and macOS, port numbers smaller than 1024 require root privileges.}

\item{\code{parse}}{A \verb{function (req)} that is run on the foreground process to
transform the HTTP request prior to passing it to \code{handler}. \code{req} is
the environment object provided by 'httpuv', amended with \verb{$ARGS} and
\verb{$COOKIES}. Return value is used as \code{req} going forward.}

\item{\code{globals}}{A list of variables to add to \code{handler}'s evaluation
environment.}

\item{\code{packages}}{Character vector of package names to load on workers.}

\item{\code{namespace}}{The name of a package to attach to the worker's
environment.}

\item{\code{init}}{A call or R expression wrapped in curly braces to evaluate on
each worker just once, immediately after start-up. Will have access
to variables defined by \code{globals} and assets from \code{packages} and
\code{namespace}. Returned value is ignored.}

\item{\code{max_cpus}}{Total number of CPU cores that can be reserved by all
running Jobs (\code{sum(cpus)}). Does not enforce limits on actual CPU
utilization.}

\item{\code{workers}}{How many background \link[jobqueue:Worker]{jobqueue::Worker} processes to start.
Set to more than \code{max_cpus} to enable interrupted workers to be
quickly swapped out with standby Workers while a replacement Worker
boots up.}

\item{\code{timeout}}{A named numeric vector indicating the maximum number of
seconds allowed for each state the job passes through, or 'total' to
apply a single timeout from 'submitted' to 'done'. Example:
\code{timeout = c(total = 2.5, running = 1)}.}

\item{\code{hooks}}{A list of functions to run when the Job state changes, of the
form \code{hooks = list(created = function (job) {...}, done = ~{...})}.
See \code{vignette('hooks')}.}

\item{\code{reformat}}{A \verb{function (job)} that is run in the foreground process to
transform the output from \code{handler}. The default, \code{reformat = NULL},
is essentially \code{function (job) { job$output }}.}

\item{\code{stop_id}}{A \verb{function (job)}. If two Jobs generate the same value from
this function, then the earlier Job will be aborted. If the returned
value is \code{NULL}, no Jobs will be stopped.}

\item{\code{copy_id}}{A \verb{function (job)}. If two Jobs generate the same value from
this function, then the later Job will clone its output from the
earlier Job. If the returned value is \code{NULL}, no Jobs will be cloned.}

\item{\code{bg}}{Where/how to run the server. \code{TRUE}: on a separate R process.
\code{FALSE}: blocking on the current R process. \code{NULL}: non-blocking on
the current R process.}

\item{\code{quiet}}{If \code{TRUE}, suppress error messages from starting the 'httpuv'
server.}

\item{\code{onHeaders}}{A \verb{function (request)} triggered when headers are
received by 'httpuv'. Return NULL to continue normal processing of
the request, or a Rook response to send that response, stop
processing the request, and ask the client to close the connection.
(This can be used to implement upload size limits, for example.)}

\item{\code{staticPaths}}{A named list of paths that will be served without
invoking \code{handler()} or \code{onHeaders()}. The name of each one is the
URL path, and the value is either a string referring to a local path,
or an object created by the \code{httpuv::staticPath()} function.}

\item{\code{staticPathOptions}}{A set of default options to use when serving
static paths. If not set or NULL, then it will use the result from
calling \code{httpuv::staticPathOptions()} with no arguments.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{WebQueue} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WebQueue-print"></a>}}
\if{latex}{\out{\hypertarget{method-WebQueue-print}{}}}
\subsection{Method \code{print()}}{
Print method for a WebQueue.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WebQueue$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Arguments are not used currently.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WebQueue-stop"></a>}}
\if{latex}{\out{\hypertarget{method-WebQueue-stop}{}}}
\subsection{Method \code{stop()}}{
Shuts down the WebQueue and all associated subprocesses. Stopped Jobs
will have their \verb{$output} set to a object of class \verb{<interrupt/condition>}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WebQueue$stop(reason = "server stopped")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{reason}}{A brief message for the condition object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This WebQueue, invisibly.
}
}
}
