% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resize.R
\name{resize}
\alias{resize}
\title{Resize stimuli}
\usage{
resize(stimuli, width = NULL, height = NULL)
}
\arguments{
\item{stimuli}{list of stimuli}

\item{width, height}{new dimensions (in pixels or percent if < 10)}
}
\value{
list of stimuli with resized tems and/or images
}
\description{
Resize images and templates to the specified width and height.
}
\examples{
stimuli <- demo_stim()

# set width to proportion, height proportional
resize(stimuli, .5) |> draw_tem()

# set width and height separately by pixels
resize(stimuli, 400, 250) |> draw_tem()

}
\seealso{
Stimulus manipulation functions
\code{\link{align}()},
\code{\link{crop_tem}()},
\code{\link{crop}()},
\code{\link{greyscale}()},
\code{\link{horiz_eyes}()},
\code{\link{image_func}()},
\code{\link{mask_oval}()},
\code{\link{mask}()},
\code{\link{mirror}()},
\code{\link{pad}()},
\code{\link{rotate}()},
\code{\link{to_size}()}
}
\concept{manipulators}
