% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stimlist.R
\name{require_tems}
\alias{require_tems}
\title{Require templates}
\usage{
require_tems(stimuli, all_same = FALSE)
}
\arguments{
\item{stimuli}{list of stimuli}

\item{all_same}{logical; whether all images should have the same template}
}
\value{
list of stimuli with tems
}
\description{
Checks a list of stimuli for templates and omits images without a template. If all_same = TRUE, checks that all the templates are the same type. Errors if no images have a template or not all templates are the same (when all_same == TRUE).
}
\examples{
stimuli <- demo_stim()
have_tems <- require_tems(stimuli)

\dontrun{
# produces an error because no tems
no_tems <- stimuli |> remove_tem()
require_tems(no_tems)

# warns that some images were removed
mix_tems <- c(stimuli, no_tems)
have_tems <- require_tems(mix_tems)

# produces an error because tems are different
demo_tems() |> require_tems(all_same = TRUE)
}
}
\seealso{
Template functions
\code{\link{auto_delin}()},
\code{\link{average_tem}()},
\code{\link{centroid}()},
\code{\link{change_lines}()},
\code{\link{delin}()},
\code{\link{draw_tem}()},
\code{\link{features}()},
\code{\link{get_point}()},
\code{\link{remove_tem}()},
\code{\link{same_tems}()},
\code{\link{squash_tem}()},
\code{\link{subset_tem}()},
\code{\link{tem_def}()},
\code{\link{viz_tem_def}()}
}
\concept{tem}
