% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare}
\alias{compare}
\title{Image Comparison}
\usage{
compare(stimuli, ref_stim, metric = "MSE", fuzz = 0, scale = FALSE)
}
\arguments{
\item{stimuli}{Stimuli to compare to the ref_stim}

\item{ref_stim}{A stim, 1-item stimlist, or the name or index of the comparison item in stim}

\item{metric}{string with a metric from magick::metric_types(): "Undefined", "AE", "Fuzz", "MAE", "MEPP", "MSE", "NCC", "PAE", "PHASH", "PSNR", "RMSE"}

\item{fuzz}{relative color distance (value between 0 and 100) to be considered similar in the filling algorithm (only useful for AE)}

\item{scale}{whether to scale the values so that the maximum value is 1 and the minimum is 0 (only useful when stim is more than 1 image and includes ref_stim)}
}
\value{
Difference metric
}
\description{
This is just a convenient way to use magick::compareare with webmorph stimuli. It defaults to the "MSE" metric, which gives a linearly increasing score to images along a morph continuum.
}
\details{
Metric Types
\itemize{
\item Undefined: ?
\item AE: Absolute Error
\item Fuzz: ?
\item MAE: Mean Absolute Error
\item MEPP: Mean Error Per Pixel
\item MSE: Mean Squared Error
\item NCC: Normalized Cross Correlation
\item PAE: Peak Absolute Error
\item PHASH: Perceptual Hash
\item PSNR: Peak Signal-to-Noise Ratio
\item RMSE: Root Mean Squared Error
}

How these metrics behave when comparing a morph continuum to its first image.

Increases with morph distance:
\itemize{
\item very strong negative exponential decay at 0 fuzz; more linear with higher fuzz: AE
\item strong negative exponential decay: PAE
\item slight negative exponential decay: Fuzz, RMSE
\item linear: MAE, MEPP, MSE
\item no idea: PHASH
}

Decreases with morph distance:
\itemize{
\item linear: NCC, Undefined
\item slight exponential decay: PSNR
}
}
\examples{
stimuli <- demo_stim()
compare(stimuli, stimuli$m_multi)
compare(stimuli, stimuli$m_multi, "AE")
compare(stimuli, stimuli$m_multi, "AE", fuzz = 5)
}
\seealso{
Other info: 
\code{\link{add_info}()},
\code{\link{get_info}()},
\code{\link{get_point}()},
\code{\link{height}()},
\code{\link{metrics}()},
\code{\link{rename_stim}()},
\code{\link{width}()}
}
\concept{info}
