% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animate.R
\name{animate}
\alias{animate}
\title{Create an animated gif from a list of stimuli}
\usage{
animate(stimuli, fps = 1, loop = 0, rev = FALSE)
}
\arguments{
\item{stimuli}{list of stimuli}

\item{fps}{frames per second}

\item{loop}{how many times to loop the animation (0 = infinite)}

\item{rev}{whether to loop back and forth (TRUE) or in one direction (FALSE)}
}
\value{
magick image
}
\description{
Create an animated gif from a list of stimuli
}
\examples{
\donttest{
# slideshow of images (1/second)
demo_stim() |> animate()

# rotate a face
degrees <- seq(0, 350, 10)
demo_stim(1) |>
  mask() |>
  rep(length(degrees)) |>
  rotate(degrees) |>
  animate(fps = 10)
}
}
\seealso{
Stimulus creating functions
\code{\link{as_stimlist}()},
\code{\link{blank}()},
\code{\link{new_stimlist}()},
\code{\link{new_stim}()},
\code{\link{read_img}()},
\code{\link{read_stim}()},
\code{\link{read_tem}()},
\code{\link{write_stim}()}
}
\concept{stim}
