% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mw-range-parser.R
\name{mw_range_parser}
\alias{mw_range_parser}
\title{Middleware to parse a Range header}
\usage{
mw_range_parser()
}
\value{
Handler function.
}
\description{
Adds the requested ranges to the \code{ranges} element of the request
object. \code{request$ranges} is a data frame with two columns, \code{from} and
\code{to}. Each row corresponds one requested interval.
}
\details{
When the last \code{n} bytes of the file are requested, the matrix row is set
to \code{c(0, -n)}. When all bytes after a \code{p} position are requested, the
matrix row is set to \code{c(p, Inf)}.

If the intervals overlap, then \code{ranges} is not set, i.e. the \code{Range}
header is ignored.

If its syntax is invalid or the unit is not \code{bytes}, then the
\code{Range} header is ignored.
}
\seealso{
Other middleware: 
\code{\link{mw_cookie_parser}()},
\code{\link{mw_etag}()},
\code{\link{mw_json}()},
\code{\link{mw_log}()},
\code{\link{mw_multipart}()},
\code{\link{mw_raw}()},
\code{\link{mw_static}()},
\code{\link{mw_text}()},
\code{\link{mw_urlencoded}()}
}
\concept{middleware}
