% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webdeveloper.R
\name{parseMultiPartFormData}
\alias{parseMultiPartFormData}
\title{Parse multi-part form data}
\usage{
parseMultiPartFormData(x, boundary)
}
\arguments{
\item{x}{A vector.}

\item{boundary}{A string, the boundary used for the multi-part form data}
}
\value{
A named list.
}
\description{
Parse multi-part form data
}
\examples{
parseMultiPartFormData(
x = c(
  "------WebKitFormBoundaryfBloeH49iOmYtO5A",
  "Content-Disposition: form-data; name=\"form_name\"",
  "",
  "Example",
  "------WebKitFormBoundaryfBloeH49iOmYtO5A",
  "Content-Disposition: form-data; name=\"form_id\"",
  "",
  "test",
  "------WebKitFormBoundaryfBloeH49iOmYtO5A",
  "Content-Disposition: form-data; name=\"desktop_file\"; filename=\"limit_type.csv\"",
  "Content-Type: text/csv",
  "",
  "limit_type",
  "Aggregate",
  "Occurrence",
  "------WebKitFormBoundaryfBloeH49iOmYtO5A--"
),
boundary = parseContentTypeHeader(
"multipart/form-data; boundary=----WebKitFormBoundaryfBloeH49iOmYtO5A")[['boundary']]
)
}
