% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemspider.R
\name{cs_control}
\alias{cs_control}
\title{Control ChemSpider API requests}
\usage{
cs_control(
  datasources = vector(),
  order_by = "default",
  order_direction = "default",
  include_all = FALSE,
  complexity = "any",
  isotopic = "any"
)
}
\arguments{
\item{datasources}{character; specifies the databases to query. Use
\code{cs_datasources()} to retrieve available ChemSpider data sources.}

\item{order_by}{character; specifies the sort order for the results.
Valid values are \code{"default"}, \code{"recordId"}, \code{"massDefect"},
\code{"molecularWeight"}, \code{"referenceCount"}, \code{"dataSourceCount"},
\code{"pubMedCount"}, \code{"rscCount"}.}

\item{order_direction}{character; specifies the sort order for the results.
Valid values are \code{"default"}, \code{"ascending"}, \code{"descending"}.}

\item{include_all}{logical; see details.}

\item{complexity}{character; see details.
Valid values are \code{"any"} \code{"single"}, \code{"multiple"}.}

\item{isotopic}{character; see details.
Valid values are \code{"any"}, \code{"labeled"}, \code{"unlabeled"}.}
}
\value{
Returns a list of specified control options.
}
\description{
For some ChemSpider API requests, you can also specify various control
options. This function is used to set these control options.
}
\details{
The only function that currently uses \code{databases} is
\code{get_csid()} and only when you query a CSID from a formula. This
parameter is disregarded in all other queries.

Setting \code{include_all} to \code{TRUE} will consider records
which contain all of the filter criteria specified in the request. Setting
it to \code{FALSE} will consider records which contain any of the filter
criteria.

A compound with a  \code{complexity} of \code{"multiple"} has more
than one disconnected system in it or a metal atom or ion.
}
\note{
This is a full list of all API control options.
However, not all of these options are used in all functions.
Each API uses a subset of these controls.
The controls that are available for a given function are indicated within the
documentation of the function.
}
\examples{
cs_control()
cs_control(order_direction = "descending")
}
\references{
\url{https://developer.rsc.org/docs/compounds-v1-trial/1/overview}
}
\seealso{
\code{\link{get_csid}}
}
