% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pubchem.R
\name{pc_synonyms}
\alias{pc_synonyms}
\title{Search synonyms in pubchem}
\usage{
pc_synonyms(query, from = "name", verbose = TRUE, arg = NULL, ...)
}
\arguments{
\item{query}{character; search term.}

\item{from}{character; type of input, can be one of 'name' (default), 'cid', 'sid', 'aid', 'smiles', 'inchi', 'inchikey'}

\item{verbose}{logical; should a verbose output be printed on the console?}

\item{arg}{character; optinal arguments like 'name_type=word' to match individual words.}

\item{...}{optional arguments}
}
\value{
a character vector.
}
\description{
Search synonyms using PUG-REST,
see \url{https://pubchem.ncbi.nlm.nih.gov/}.
}
\examples{
\donttest{
pc_synonyms('Aspirin')
pc_synonyms(c('Aspirin', 'Triclosan'))
pc_synonyms(5564, from = 'cid')
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
\references{
Wang, Y., J. Xiao, T. O. Suzek, et al. 2009 PubChem: A Public Information System for
Analyzing Bioactivities of Small Molecules. Nucleic Acids Research 37: 623–633.

Kim, Sunghwan, Paul A. Thiessen, Evan E. Bolton, et al. 2016
PubChem Substance and Compound Databases. Nucleic Acids Research 44(D1): D1202–D1213.

Kim, S., Thiessen, P. A., Bolton, E. E., & Bryant, S. H. (2015).
PUG-SOAP and PUG-REST: web services for programmatic access to chemical information in PubChem. Nucleic acids research, gkv396.
}

